/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.proxy.xmlrpc_client;

import com.spin.domain.BridgeInfo;
import com.spin.domain.DataTrace;
import com.spin.domain.Group;
import com.spin.domain.MonitoredItems;
import com.spin.domain.Program;
import com.spin.domain.ProgramResult;
import com.spin.domain.RPM;
import com.spin.domain.SerialNumber;
import com.spin.domain.SpinSoftwareVersion;
import com.spin.domain.ToolInfo;
import com.spin.domain.program_goal.ExtractionGoal;
import com.spin.domain.program_goal.PositionGoal;
import com.spin.domain.program_goal.ProgramGoal;
import com.spin.domain.program_goal.TorqueGoal;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Torque;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.jetbrains.annotations.NotNull;

public class XmlRpcBridgeClient {
    private static final int connectionTimeout_ms = 1500;
    private static final int replyTimeout_ms = 1500;
    private static final Object[] noParams = XmlRpcBridgeClient.params(new Object[0]);
    @NotNull
    private final XmlRpcClient client;
    @NotNull
    private final XmlRpcClientConfigImpl clientConfig;
    @NotNull
    private final SimpleValueFactory valueFactory;
    private final int port;

    public XmlRpcBridgeClient(int port, @NotNull SimpleValueFactory valueFactory) {
        this.port = port;
        this.valueFactory = valueFactory;
        this.clientConfig = new XmlRpcClientConfigImpl();
        this.client = new XmlRpcClient();
        this.clientConfig.setConnectionTimeout(1500);
        this.clientConfig.setReplyTimeout(1500);
        this.client.setConfig((XmlRpcClientConfig)this.clientConfig);
    }

    @NotNull
    private static Object[] params(Object ... args) {
        return args;
    }

    public void setIpAddress(@NotNull InetAddress address) {
        try {
            URL url = new URL("http://" + address.getHostAddress() + ":" + this.port + "/RPC2");
            this.clientConfig.setServerURL(url);
        }
        catch (MalformedURLException e) {
            SpinLog.print("BridgeClient.setIpAddress() MalformedURLException " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public String connect() throws XmlRpcException {
        return (String)this.client.execute("ConnectUr", noParams);
    }

    @NotNull
    public MonitoredItems monitorItems() throws XmlRpcException {
        Map result = (Map)this.client.execute("MonitorItems", noParams);
        return new MonitoredItems((Boolean)result.get("beat"), (Boolean)result.get("freeBtn"), (Boolean)result.get("frontBtn"), (Boolean)result.get("toolCon"), (String)result.get("resUUID"), (Integer)result.get("progID"));
    }

    @NotNull
    public BridgeInfo bridgeInfo() throws XmlRpcException {
        HashMap result = (HashMap)this.client.execute("BridgeInfo", noParams);
        SerialNumber serialNumber = SerialNumber.parse((String)result.get("serialNumber"));
        SpinSoftwareVersion softwareVersion = SpinSoftwareVersion.parse((String)result.get("softwareVersion"));
        if (result.containsKey("minURCapsVersion")) {
            SpinSoftwareVersion minURCapsVersion = SpinSoftwareVersion.parse((String)result.get("minURCapsVersion"));
            return new BridgeInfo(serialNumber, softwareVersion, minURCapsVersion);
        }
        return new BridgeInfo(serialNumber, softwareVersion);
    }

    public void enableExhibitionMode() throws XmlRpcException {
        this.client.execute("EnableFairMode", noParams);
    }

    @NotNull
    public ToolInfo toolInfo() throws XmlRpcException {
        HashMap result = (HashMap)this.client.execute("ToolInfo", noParams);
        SerialNumber serialNumber = SerialNumber.parse((String)result.get("serialNumber"));
        SpinSoftwareVersion softwareVersion = SpinSoftwareVersion.parse((String)result.get("softwareVersion"));
        RPM minSpeed = new RPM((Integer)result.get("minSpeed_rpm"));
        RPM maxSpeed = new RPM((Integer)result.get("maxSpeed_rpm"));
        boolean needsFirmwareUpdate = (Boolean)result.get("needsFirmwareUpdate");
        return new ToolInfo(serialNumber, softwareVersion, minSpeed, maxSpeed, needsFirmwareUpdate);
    }

    @NotNull
    public Set<Program> programs() throws XmlRpcException {
        try {
            return Arrays.stream((Object[])this.client.execute("Programs", noParams)).map(this::extractProgram).collect(Collectors.toSet());
        }
        catch (IllegalArgumentException e) {
            SpinLog.print("BridgeClient.programs() IllegalArgumentException " + e.getMessage());
            throw new XmlRpcException("Invalid data", (Throwable)e);
        }
    }

    @NotNull
    public Set<Group> groups() throws XmlRpcException {
        try {
            return Arrays.stream((Object[])this.client.execute("Groups", noParams)).map(this::extractGroup).collect(Collectors.toSet());
        }
        catch (IllegalArgumentException e) {
            SpinLog.print("BridgeClient.groups() IllegalArgumentException " + e.getMessage());
            throw new XmlRpcException("Invalid data", (Throwable)e);
        }
    }

    public boolean acknowledgeErrors() throws XmlRpcException {
        return (Boolean)this.client.execute("AcknowledgeErrors", noParams);
    }

    public boolean safetyShieldDoHoming() throws XmlRpcException {
        return (Boolean)this.client.execute("SafetyShieldDoHoming", noParams);
    }

    public boolean safetyShieldStop() throws XmlRpcException {
        return (Boolean)this.client.execute("SafetyShieldStop", noParams);
    }

    public boolean safetyShieldLockBit() throws XmlRpcException {
        return (Boolean)this.client.execute("SafetyShieldLockBit", noParams);
    }

    public boolean safetyShieldReleaseBit() throws XmlRpcException {
        return (Boolean)this.client.execute("SafetyShieldReleaseBit", noParams);
    }

    public boolean safetyShieldCoverBit() throws XmlRpcException {
        return (Boolean)this.client.execute("SafetyShieldCoverBit", noParams);
    }

    public boolean safetyShieldCoverScrew(Length length) throws XmlRpcException {
        return (Boolean)this.client.execute("SafetyShieldCoverScrew", XmlRpcBridgeClient.params(length.getAs(Length.Unit.MM)));
    }

    public boolean safetyShieldFollowRobot() throws XmlRpcException {
        return (Boolean)this.client.execute("SafetyShieldFollowRobot", noParams);
    }

    public boolean safetyShieldMoveTo(Length length) throws XmlRpcException {
        return (Boolean)this.client.execute("SafetyShieldMoveToPosition", XmlRpcBridgeClient.params(length.getAs(Length.Unit.MM)));
    }

    public boolean startMotor(int speed) throws XmlRpcException {
        int rampDuration_ms = 600;
        return (Boolean)this.client.execute("StartMotor", XmlRpcBridgeClient.params(speed, rampDuration_ms));
    }

    public boolean stopMotor() throws XmlRpcException {
        return (Boolean)this.client.execute("StopMotor", noParams);
    }

    ProgramResult.Evaluation getEvaluation(int evaluation) {
        SpinLog.print("getEvaluation");
        switch (evaluation) {
            case 0: {
                return ProgramResult.Evaluation.FAULT;
            }
            case 1: {
                return ProgramResult.Evaluation.NOT_OK;
            }
            case 2: {
                return ProgramResult.Evaluation.OK;
            }
        }
        SpinLog.print("getEvaluation IllegalArgumentException");
        throw new IllegalArgumentException("Unknown evaluation: " + evaluation);
    }

    @NotNull
    public ProgramResult latestResult() throws XmlRpcException {
        HashMap result = (HashMap)this.client.execute("LatestResult", noParams);
        return this.extractDataTrace(result.get("positionTrace")).getSampleRate() == 0 ? new ProgramResult("", LocalDateTime.now(), ProgramResult.Evaluation.FAULT, this.valueFactory.createLength(0.0, Length.Unit.MM), this.valueFactory.createTorque(0.0, Torque.Unit.NM), new PositionGoal(this.valueFactory.createLength(0.0, Length.Unit.MM)), new DataTrace(0, new float[]{0.0f}), new DataTrace(0, new float[]{0.0f})) : new ProgramResult((String)result.get("uuid"), this.parseTimeStamp(result.get("timestamp")), this.getEvaluation((Integer)result.get("evaluation")), this.valueFactory.createLength(((Double)result.get("finalInsertionDepth")).doubleValue(), Length.Unit.MM), this.valueFactory.createTorque(((Double)result.get("finalTorque")).doubleValue(), Torque.Unit.NM), this.programGoalFrom(result.get("goalType"), result.get("goalValue")), this.extractDataTrace(result.get("positionTrace")), this.extractDataTrace(result.get("torqueTrace")));
    }

    @NotNull
    private LocalDateTime parseTimeStamp(@NotNull Object timestamp) {
        return LocalDateTime.ofEpochSecond(((Integer)timestamp).intValue(), 0, ZoneOffset.UTC);
    }

    @NotNull
    private ProgramGoal programGoalFrom(@NotNull Object goalType, @NotNull Object goalValue) {
        switch ((Integer)goalType) {
            case 0: {
                return new ExtractionGoal();
            }
            case 1: {
                return new TorqueGoal(this.valueFactory.createTorque(((Double)goalValue).doubleValue(), Torque.Unit.NM));
            }
            case 2: {
                return new PositionGoal(this.valueFactory.createLength(((Double)goalValue).doubleValue(), Length.Unit.MM));
            }
        }
        throw new IllegalArgumentException("Unsupported goal type");
    }

    @NotNull
    private DataTrace extractDataTrace(@NotNull Object traceObject) {
        Map traceMap = (Map)traceObject;
        int sampleRate = (Integer)traceMap.get("sampleRate");
        Object[] trace = (Object[])traceMap.get("trace");
        float[] floatTrace = new float[trace.length];
        for (int i = 0; i < trace.length; ++i) {
            if (trace[i] instanceof Float) {
                floatTrace[i] = ((Float)trace[i]).floatValue();
                continue;
            }
            if (trace[i] instanceof Double) {
                floatTrace[i] = ((Double)trace[i]).floatValue();
                continue;
            }
            throw new IllegalArgumentException("Unsupported trace type");
        }
        return new DataTrace(sampleRate, floatTrace);
    }

    @NotNull
    private Group extractGroup(@NotNull Object groupObject) {
        Map groupMap = (Map)groupObject;
        UUID uuid = UUID.fromString((String)groupMap.get("uuid"));
        String name = (String)groupMap.get("name");
        Set<UUID> programs = Arrays.stream((Object[])groupMap.get("programUUIDs")).map(this::extractUUID).collect(Collectors.toSet());
        return new Group(uuid, name, programs);
    }

    @NotNull
    private UUID extractUUID(@NotNull Object uuidObject) {
        return UUID.fromString((String)uuidObject);
    }

    @NotNull
    private Program extractProgram(@NotNull Object programObject) {
        Map programMap = (Map)programObject;
        UUID uuid = UUID.fromString((String)programMap.get("uuid"));
        String name = (String)programMap.get("name");
        Length refDepth = this.valueFactory.createLength(((Double)programMap.get("reference_depth_mm")).doubleValue(), Length.Unit.MM);
        Length startDepth = this.valueFactory.createLength(((Double)programMap.get("start_depth_mm")).doubleValue(), Length.Unit.MM);
        Length initialSafetyShieldPosition = this.valueFactory.createLength(((Double)programMap.get("inital_safety_shield_position_mm")).doubleValue(), Length.Unit.MM);
        Force drivingForce = this.valueFactory.createForce(((Double)programMap.get("driving_force_N")).doubleValue(), Force.Unit.N);
        return new Program(uuid, name, refDepth, startDepth, initialSafetyShieldPosition, drivingForce);
    }
}

