/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.detach_bit;

import com.spin.core.program_node.detach_bit.DetachBitData;
import com.spin.core.program_node.detach_bit.DetachBitScriptGenerator;
import com.spin.core.program_node.detach_bit.DetachBitText;
import com.spin.core.program_node.detach_bit.DetachBitView;
import com.spin.domain.BitChangingStation;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DetachBitContribution
implements ProgramNodeContribution {
    private static final Map<BitChangingStation.Bit, String> bitPostfixes = new HashMap<BitChangingStation.Bit, String>(){
        {
            this.put(BitChangingStation.Bit.BIT_1, " 1");
            this.put(BitChangingStation.Bit.BIT_2, " 2");
            this.put(BitChangingStation.Bit.BIT_3, " 3");
        }
    };
    @NotNull
    private final DetachBitView view;
    @NotNull
    private final DetachBitData data;
    @NotNull
    private final DetachBitScriptGenerator scriptGenerator;
    @NotNull
    private final TextResource textResource;

    public DetachBitContribution(@NotNull DetachBitView view, @NotNull DetachBitData data, @NotNull DetachBitScriptGenerator scriptGenerator, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.view = view;
        this.data = data;
        this.scriptGenerator = scriptGenerator;
        this.textResource = apiProvider.getTextResource();
    }

    public void openView() {
        this.view.setStations(this.data.bitChangingStations());
        this.view.setSelectedBit(this.data.selectedBit());
        this.view.setApproachEnabled(this.data.approachEnabled());
        this.view.setSelectedStation(this.data.selectedStation());
    }

    public void closeView() {
    }

    @NotNull
    public String getTitle() {
        String title = this.textResource.load(DetachBitText.DETACH_BIT);
        return title + bitPostfixes.getOrDefault((Object)this.data.selectedBit(), "");
    }

    public boolean isDefined() {
        return this.data.isValidConfiguration();
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        this.scriptGenerator.generateScript(writer, this.textResource, this.data);
    }

    void selectBit(@NotNull BitChangingStation.Bit bit) {
        this.data.setSelectedBit(bit);
    }

    void selectStation(@NotNull BitChangingStation station) {
        this.data.setSelectedStation(station);
    }

    void setApproachEnabled(boolean enabled) {
        this.data.setApproachEnabled(enabled);
    }
}

