/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup;

import com.spin.api.ExtendedProgramAPIProvider;
import com.spin.bridge_communication.program_data.ProgramDataConsumer;
import com.spin.bridge_communication.program_data.ProgramDataProvider;
import com.spin.core.installation_node.InstallationContribution;
import com.spin.domain.Part;
import com.spin.domain.Program;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.variable.GlobalVariable;
import com.ur.urcap.api.domain.variable.Variable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrewdrivingSetupData {
    @NotNull
    private final DataModel model;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final ProgramDataProvider programDataProvider;
    @NotNull
    private Runnable availablePartsChangedCallback = () -> {};
    @NotNull
    private final ProgramDataConsumer programDataConsumer = parts -> this.availablePartsChangedCallback.run();

    ScrewdrivingSetupData(@NotNull DataModel model, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.model = model;
        ProgramAPI programAPI = apiProvider.getProgramAPIProvider().getProgramAPI();
        this.undoRedoManager = programAPI.getUndoRedoManager();
        this.programDataProvider = ((InstallationContribution)programAPI.getInstallationNode(InstallationContribution.class)).getProgramDataProvider();
    }

    void setOnPartsChangedCallback(@NotNull Runnable callback) {
        this.availablePartsChangedCallback = callback;
        this.programDataProvider.registerConsumer(this.programDataConsumer);
    }

    void clearOnPartsChangedCallback() {
        this.availablePartsChangedCallback = () -> {};
        this.programDataProvider.unregisterConsumer(this.programDataConsumer);
    }

    @NotNull
    Set<Part> availableParts() {
        return this.programDataProvider.getData();
    }

    @NotNull
    List<Program> availablePrograms() {
        Part selectedPart = this.selectedPart();
        return selectedPart == null ? Collections.emptyList() : selectedPart.programs();
    }

    @Deprecated
    @Nullable
    Part selectedPart(@NotNull Collection<Part> availableParts) {
        Integer selectedID = this.loadSelectedPartID();
        return selectedID == null ? null : (Part)availableParts.stream().filter(part -> part.id() == selectedID.intValue()).findFirst().orElse(null);
    }

    @Nullable
    Part selectedPart() {
        Integer selectedID = this.loadSelectedPartID();
        return selectedID == null ? null : (Part)this.availableParts().stream().filter(part -> part.id() == selectedID.intValue()).findFirst().orElse(null);
    }

    void setSelectedPart(@NotNull Part part) {
        this.undoRedoManager.recordChanges(() -> this.model.set("part", part.id()));
    }

    @Nullable
    private Integer loadSelectedPartID() {
        int id = this.model.get("part", -1);
        return id == -1 ? null : Integer.valueOf(id);
    }

    @Deprecated
    @Nullable
    Program selectedProgram(@NotNull Collection<Program> availablePrograms) {
        Integer selectedID = this.loadSelectedProgramID();
        return selectedID == null ? null : (Program)availablePrograms.stream().filter(program -> program.id() == selectedID.intValue()).findFirst().orElse(null);
    }

    @Nullable
    Program selectedProgram() {
        Integer selectedID = this.loadSelectedProgramID();
        return selectedID == null ? null : (Program)this.availablePrograms().stream().filter(program -> program.id() == selectedID.intValue()).findFirst().orElse(null);
    }

    void setSelectedProgram(@NotNull Program program) {
        this.undoRedoManager.recordChanges(() -> this.model.set("program", program.id()));
    }

    void clearSelectedProgram() {
        this.undoRedoManager.recordChanges(() -> this.model.remove("program"));
    }

    @Nullable
    private Integer loadSelectedProgramID() {
        int id = this.model.get("program", -1);
        return id == -1 ? null : Integer.valueOf(id);
    }

    @Nullable
    Pose screwPose() {
        return this.model.get("pose", (Pose)null);
    }

    void setScrewPose(@NotNull Pose pose) {
        this.undoRedoManager.recordChanges(() -> this.model.set("pose", pose));
    }

    boolean approachEnabled() {
        return this.model.get("approachEnabled", true);
    }

    void setApproachEnabled(boolean enabled) {
        this.undoRedoManager.recordChanges(() -> this.model.set("approachEnabled", enabled));
    }

    public boolean isValid() {
        return this.selectedPart() != null && this.selectedProgram() != null && (this.screwPose() != null || this.useSpinTarget());
    }

    public void setUseSpinTarget(boolean selected) {
        this.undoRedoManager.recordChanges(() -> this.model.set("useSpinTarget", selected));
    }

    public boolean useSpinTarget() {
        return this.model.get("useSpinTarget", false);
    }

    public boolean useOnSuccess() {
        return this.model.get("useOnSuccess", false);
    }

    public void setUseOnSuccess(boolean selected) {
        this.undoRedoManager.recordChanges(() -> this.model.set("useOnSuccess", selected));
    }

    public boolean useOnFailure() {
        return this.model.get("useOnFailure", false);
    }

    public void setUseOnFailure(boolean selected) {
        this.undoRedoManager.recordChanges(() -> this.model.set("useOnFailure", selected));
    }

    public void setSpinTarget(GlobalVariable spinTarget) {
        this.undoRedoManager.recordChanges(() -> this.model.set("spinTarget", (Variable)spinTarget));
    }

    public Variable spinTarget() {
        return this.model.get("spinTarget", (Variable)null);
    }
}

