/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup;

import com.spin.api.ExtendedProgramAPIProvider;
import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusListener;
import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusProvider;
import com.spin.core.installation_node.InstallationContribution;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupData;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupText;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupView;
import com.spin.core.program_node.screwdriving_setup.drive_screw.DriveScrewInterface;
import com.spin.core.program_node.screwdriving_setup.drive_screw.DriveScrewService;
import com.spin.core.program_node.screwdriving_setup.on_fault.OnFaultService;
import com.spin.core.program_node.screwdriving_setup.on_success.OnSuccessService;
import com.spin.domain.BridgeInfo;
import com.spin.domain.Part;
import com.spin.domain.Program;
import com.spin.i18n.TextResource;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.program.ProgramModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.builtin.AssignmentNode;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.AssignmentNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.AssignmentNodeConfigFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.ExpressionAssignmentNodeConfig;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback2;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovement;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.expression.ExpressionBuilder;
import com.ur.urcap.api.domain.value.expression.InvalidExpressionException;
import com.ur.urcap.api.domain.variable.GlobalVariable;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ScrewdrivingSetupContribution
implements ProgramNodeContribution {
    @NotNull
    private final ScrewdrivingSetupView view;
    @NotNull
    private final ScrewdrivingSetupData data;
    @NotNull
    private final UserInteraction userInteraction;
    @NotNull
    private final BridgeConnectionStatusProvider bridgeConnectionStatusProvider;
    @NotNull
    private final String nodeTitle;
    @NotNull
    private final BridgeConnectionStatusListener bridgeConnectionStatusListener = this.createBridgeConnectionStatusListener();
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final AssignmentNode targetAssignmentNode;
    @NotNull
    private final URCapProgramNode driveScrewSubNode;
    @NotNull
    private final URCapProgramNode onSuccessNode;
    @NotNull
    private final URCapProgramNode onFaultNode;
    @NotNull
    private ProgramModel programModel;
    GlobalVariable spinTarget;

    public ScrewdrivingSetupContribution(@NotNull ScrewdrivingSetupView view, @NotNull ScrewdrivingSetupData data, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.undoRedoManager = apiProvider.getProgramAPIProvider().getProgramAPI().getUndoRedoManager();
        InstallationContribution installationNode = (InstallationContribution)apiProvider.getProgramAPIProvider().getProgramAPI().getInstallationNode(InstallationContribution.class);
        this.view = view;
        this.data = data;
        this.nodeTitle = apiProvider.getTextResource().load(ScrewdrivingSetupText.SCREWDRIVING_SETUP);
        this.textResource = apiProvider.getTextResource();
        this.userInteraction = apiProvider.getProgramAPIProvider().getUserInterfaceAPI().getUserInteraction();
        this.bridgeConnectionStatusProvider = installationNode.getBridgeConnectionStatusProvider();
        this.programModel = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel();
        this.targetAssignmentNode = this.programModel.getProgramNodeFactory().createAssignmentNode();
        this.driveScrewSubNode = this.programModel.getProgramNodeFactory().createURCapProgramNode(DriveScrewService.class);
        this.onSuccessNode = this.programModel.getProgramNodeFactory().createURCapProgramNode(OnSuccessService.class);
        this.onFaultNode = this.programModel.getProgramNodeFactory().createURCapProgramNode(OnFaultService.class);
        ExpressionBuilder expressionBuilder = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().createExpressionBuilder();
        try {
            this.spinTarget = apiProvider.getProgramAPIProvider().getProgramAPI().getVariableModel().getVariableFactory().createGlobalVariable("spin_target");
            AssignmentNodeConfigFactory assignmentNodeConfigFactory = this.targetAssignmentNode.getConfigFactory();
            ExpressionAssignmentNodeConfig targetAssignmentNodeConfig = assignmentNodeConfigFactory.createExpressionConfig((Variable)this.spinTarget, expressionBuilder.build());
            this.targetAssignmentNode.setConfig((AssignmentNodeConfig)targetAssignmentNodeConfig);
        }
        catch (VariableException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InvalidExpressionException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        data.setSpinTarget(this.spinTarget);
        try {
            this.programModel.getRootTreeNode((ProgramNodeContribution)this).addChild((ProgramNode)this.driveScrewSubNode);
            this.programModel.getRootTreeNode((ProgramNodeContribution)this).addChild((ProgramNode)this.onSuccessNode);
            this.programModel.getRootTreeNode((ProgramNodeContribution)this).addChild((ProgramNode)this.onFaultNode);
            this.programModel.getRootTreeNode((ProgramNodeContribution)this).setChildSequenceLocked(true);
        }
        catch (TreeStructureException e) {
            e.printStackTrace();
        }
    }

    public void openView() {
        this.updateSelectors();
        this.updateTeachButtonStyle();
        this.updateBridgeConnectionStatus();
        this.data.setOnPartsChangedCallback(this::updateSelectors);
        this.view.setApproachEnabled(this.data.approachEnabled());
        this.view.enableVerifyPositionButton(this.data.screwPose() != null);
        this.view.setSpinTargetEnabled(this.data.useSpinTarget());
        this.bridgeConnectionStatusProvider.registerListener(this.bridgeConnectionStatusListener);
    }

    public void closeView() {
        this.data.clearOnPartsChangedCallback();
        this.bridgeConnectionStatusProvider.unregisterListener(this.bridgeConnectionStatusListener);
    }

    @NotNull
    public String getTitle() {
        Program selectedProgram = this.data.selectedProgram();
        return selectedProgram == null ? this.nodeTitle : this.nodeTitle + ": " + selectedProgram.name();
    }

    public boolean isDefined() {
        return this.data.isValid();
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        ((DriveScrewInterface)this.driveScrewSubNode.getAs(DriveScrewInterface.class)).setData(this.data);
        writer.writeChildren();
    }

    void setSelectedPart(@NotNull Part selectedPart) {
        this.data.setSelectedPart(selectedPart);
        this.data.clearSelectedProgram();
        List<Program> programs = selectedPart.programs();
        this.view.setPrograms(programs);
        this.view.selectProgram(null);
        this.view.setNoProgramsWarningVisible(programs.isEmpty());
        this.view.enableProgramSelector(!programs.isEmpty());
    }

    void setSelectedProgram(@NotNull Program selectedProgram) {
        this.data.setSelectedProgram(selectedProgram);
    }

    void setApproachEnabled(@NotNull boolean enabled) {
        this.data.setApproachEnabled(enabled);
    }

    void getUserDefinedRobotPosition(@NotNull RobotPositionCallback2 callback) {
        this.userInteraction.getUserDefinedRobotPosition(callback);
    }

    RobotMovement getRobotMovement() {
        return this.userInteraction.getRobotMovement();
    }

    void onExitVerifyPosition() {
    }

    void addSetSpinTargetNode() {
        TreeNode driveScrewTreeNode = this.programModel.getRootTreeNode((ProgramNodeContribution)this).locateDescendantTreeNode((ProgramNode)this.driveScrewSubNode);
        this.programModel.getRootTreeNode((ProgramNodeContribution)this).setChildSequenceLocked(false);
        this.undoRedoManager.recordChanges(() -> {
            try {
                this.programModel.getRootTreeNode((ProgramNodeContribution)this).insertChildBefore(driveScrewTreeNode, (ProgramNode)this.targetAssignmentNode);
            }
            catch (TreeStructureException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
        this.programModel.getRootTreeNode((ProgramNodeContribution)this).setChildSequenceLocked(true);
    }

    void removeSetSpinTargetNode() {
        TreeNode setTargetTreeNode = this.programModel.getRootTreeNode((ProgramNodeContribution)this).locateDescendantTreeNode((ProgramNode)this.targetAssignmentNode);
        this.programModel.getRootTreeNode((ProgramNodeContribution)this).setChildSequenceLocked(false);
        this.undoRedoManager.recordChanges(() -> {
            try {
                this.programModel.getRootTreeNode((ProgramNodeContribution)this).removeChild(setTargetTreeNode);
            }
            catch (TreeStructureException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
        this.programModel.getRootTreeNode((ProgramNodeContribution)this).setChildSequenceLocked(true);
    }

    void setScrewPose(@NotNull Pose pose) {
        this.data.setScrewPose(pose);
        this.view.setButtonStyleAsReteach();
    }

    Pose getScrewPose() {
        return this.data.screwPose();
    }

    public void setUseSpinTarget(boolean selected) {
        this.data.setUseSpinTarget(selected);
        if (selected) {
            this.addSetSpinTargetNode();
        } else {
            this.removeSetSpinTargetNode();
        }
    }

    public boolean getUseSpinTarget() {
        return this.data.useSpinTarget();
    }

    private void updateSelectors() {
        Set<Part> availableParts = this.data.availableParts();
        List<Program> availablePrograms = this.data.availablePrograms();
        Part selectedPart = this.data.selectedPart();
        Program selectedProgram = this.data.selectedProgram();
        this.view.setParts(availableParts);
        this.view.selectPart(selectedPart);
        this.view.enablePartSelector(!availableParts.isEmpty());
        this.view.setNoPartsWarningVisible(availableParts.isEmpty());
        this.view.setPrograms(availablePrograms);
        this.view.selectProgram(selectedProgram);
        this.view.enableProgramSelector(!availablePrograms.isEmpty());
        this.view.setNoProgramsWarningVisible(!availableParts.isEmpty() && availablePrograms.isEmpty());
    }

    private void updateTeachButtonStyle() {
        if (this.data.screwPose() == null) {
            this.view.setButtonStyleAsTeach();
        } else {
            this.view.setButtonStyleAsReteach();
        }
    }

    private void updateBridgeConnectionStatus() {
        this.view.setNotConnectedWarningVisible(!this.bridgeConnectionStatusProvider.isConnected());
    }

    @NotNull
    private BridgeConnectionStatusListener createBridgeConnectionStatusListener() {
        return new BridgeConnectionStatusListener(){

            @Override
            public void onConnected(@NotNull BridgeInfo info) {
                ScrewdrivingSetupContribution.this.view.setNotConnectedWarningVisible(false);
            }

            @Override
            public void onDisconnected() {
                ScrewdrivingSetupContribution.this.view.setNotConnectedWarningVisible(true);
            }
        };
    }
}

