/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.daemons.communicator;

import com.spin.urcap.impl.daemons.communicator.ScriptCommand;
import com.spin.urcap.impl.daemons.communicator.ScriptSender;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;

public class ScriptExporter {
    private final String className = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1);
    private final String SEND_IP;
    private String RETURN_IP;
    private int RETURN_PORT = 5500;
    private final String RETURN_SOCKETNAME = "\"EXPORT_SOCKET\"";
    private ServerSocket server;
    private ScriptSender sender;
    private Socket returnSocket;
    private boolean isConnected;

    public ScriptExporter() {
        this.RETURN_IP = this.SEND_IP = "127.0.0.1";
        this.isConnected = false;
        this.connect();
    }

    public ScriptExporter(String Robot_IP) {
        this.RETURN_IP = this.SEND_IP = Robot_IP;
        this.isConnected = false;
        this.connect();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void connect() {
        if (!this.isConnected) {
            try {
                System.out.println(this.className + ": trying to connect!");
                this.server = new ServerSocket(this.RETURN_PORT);
                System.out.println(this.className + ": trying to connect, server created!");
                this.sender = new ScriptSender(this.SEND_IP);
                System.out.println(this.className + ": trying to connect, sender created!");
                System.out.println(this.className + ": connected!");
            }
            catch (IOException e) {
                System.out.println(this.className + ": " + e);
                e.printStackTrace();
            }
        }
    }

    public boolean close() {
        if (this.isConnected) {
            try {
                this.returnSocket.close();
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void setReturnPort(int port) {
        this.RETURN_PORT = port;
    }

    public void setReturnIP(String Return_IP) {
        this.RETURN_IP = Return_IP;
    }

    public int exportIntegerFromURScript(ScriptCommand command, String variable_name) {
        ScriptCommand newCommand = this.buildScriptCommandToExport(command, variable_name);
        String reply = this.readValueFromRobot(newCommand);
        return Integer.parseInt(reply);
    }

    public String exportStringFromURScript(ScriptCommand command, String variable_name) {
        ScriptCommand newCommand = this.buildScriptCommandToExport(command, variable_name);
        return this.readValueFromRobot(newCommand);
    }

    protected ScriptCommand buildScriptCommandToExport(ScriptCommand command, String variable_name) {
        command.setAsSecondaryProgram();
        command.appendLine("socket_open(\"" + this.RETURN_IP + "\"," + this.RETURN_PORT + "," + "\"EXPORT_SOCKET\"" + ")");
        command.appendLine("socket_send_string(" + variable_name + "," + "\"EXPORT_SOCKET\"" + ")");
        command.appendLine("socket_send_byte(13,\"EXPORT_SOCKET\")");
        command.appendLine("socket_send_byte(10,\"EXPORT_SOCKET\")");
        command.appendLine("socket_close(\"EXPORT_SOCKET\")");
        return command;
    }

    protected String readValueFromRobot(ScriptCommand commandWithReturn) {
        String input = "";
        try {
            this.sender.sendScriptCommand(commandWithReturn);
            Socket returnSocket = this.server.accept();
            BufferedReader readerFromURScript = new BufferedReader(new InputStreamReader(returnSocket.getInputStream()));
            input = readerFromURScript.readLine();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return input;
    }
}

