/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.installation_node.feeder;

import com.spin.urcap.impl.installation_node.feeder.Feeder;
import com.spin.urcap.impl.installation_node.feeder.FeederData;
import com.spin.urcap.impl.installation_node.feeder.FeederView;
import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.localization.TextResource;
import com.spin.urcap.impl.localization.UnitsResource;
import com.spin.urcap.impl.util.Compare;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback2;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementCompleteEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementErrorEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.robotposition.PositionParameters;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Speed;
import java.util.UUID;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeederContribution {
    private final FeederData feederData;
    private final InstallationAPIProvider apiProvider;
    private final SimpleValueFactory valueFactory;
    private final LanguagePack languagePack;
    private final FeederView view;
    private Length.Unit lengthUnit;
    private Speed.Unit speedUnit;
    private boolean hasBeenOpened = false;

    public FeederContribution(InstallationAPIProvider apiProvider, FeederView feederView, DataModel model) {
        this.apiProvider = apiProvider;
        this.valueFactory = apiProvider.getInstallationAPI().getValueFactoryProvider().getSimpleValueFactory();
        this.view = feederView;
        this.languagePack = new LanguagePack(apiProvider.getSystemAPI().getSystemSettings().getLocalization());
        this.feederData = new FeederData(model);
        Feeder.init(apiProvider.getInstallationAPI().getValueFactoryProvider().getSimpleValueFactory());
        System.out.println("apiProvider.getInstallationAPI().hashCode() " + apiProvider.getInstallationAPI());
    }

    public void openView() {
        if (this.hasBeenOpened) {
            return;
        }
        if (this.getUnitType().equals((Object)UnitType.METRIC)) {
            this.view.getEditFeederPanel().getLblScrewLengthUnit().setText(this.getUnitResource().UNIT_mm());
            this.view.getEditFeederPanel().getLblOffsetUnit().setText(this.getUnitResource().UNIT_mm());
            this.view.getEditFeederPanel().getLblSpeedUnit().setText(this.getUnitResource().UNIT_velocityM());
            this.view.getEditFeederPanel().getLblTimesUnit().setText(this.getUnitResource().UNIT_retriesCount());
        } else {
            this.view.getEditFeederPanel().getLblScrewLengthUnit().setText(this.getUnitResource().UNIT_in());
            this.view.getEditFeederPanel().getLblOffsetUnit().setText(this.getUnitResource().UNIT_in());
            this.view.getEditFeederPanel().getLblSpeedUnit().setText(this.getUnitResource().UNIT_velocityI());
            this.view.getEditFeederPanel().getLblTimesUnit().setText(this.getUnitResource().UNIT_retriesCount());
        }
        this.setLabels();
        this.setUnits();
        this.setMessages();
        this.fillComboBox();
        this.updateEditFeederPanel();
        this.hasBeenOpened = true;
    }

    public void fillComboBox() {
        Vector<Feeder> feeders = this.feederData.loadFeeders();
        if (feeders.size() > 0) {
            this.view.getSelectorPanel().getCombo().setItems(feeders);
            this.view.getSelectorPanel().getCombo().setSelectedIndex(0);
        }
    }

    public void setLabels() {
        this.view.getEditFeederPanel().getLblScrewLength().setText(this.getTextResource().loadScrewScrewLength());
        this.view.getEditFeederPanel().getLblOffset().setText(this.getTextResource().loadScrewOffset2());
        this.view.getEditFeederPanel().getLblSpeed().setText(this.getTextResource().loadScrewSpeed());
        this.view.getEditFeederPanel().getLblRetriesCount().setText(this.getTextResource().loadScrewRetriesCount());
        this.view.getEditFeederPanel().getBtnSetPosition().setText(this.getTextResource().feederSetScrewPosition());
        this.view.getEditFeederPanel().getBtnVerifyPosition().setText(this.getTextResource().feederVerifyPosition());
        this.view.getVerificationPanel().getBtnDone().setText(this.getTextResource().optionDone());
        this.view.getVerificationPanel().getBtnMoveAboveScrew().setText(this.getTextResource().feederMoveAboveScrew());
        this.view.getVerificationPanel().getBtnMoveToScrew().setText(this.getTextResource().feederMoveToScrew());
        this.view.getLeftPanel().getHeading().setText(this.getTextResource().feederHeadingLeftPanel());
        this.view.getVerificationPanel().getHeading().setText(this.getTextResource().feederHeadingVerificationPanel());
        this.view.getSelectorPanel().getCombo().setDefaultText(LanguagePack.getTextResource().feederComboNoFeeder());
    }

    private void setMessages() {
        this.view.getMessagePanel().getMsgNoFeeder().setMessage(LanguagePack.getTextResource().feederMsgNoFeeder());
        this.view.getMessagePanel().getMsgScrewLength().setMessage(LanguagePack.getTextResource().feederMsgScrewLength());
        this.view.getMessagePanel().getMsgSetScrewPosition().setMessage(LanguagePack.getTextResource().feederMsgSetScrewPosition());
        this.view.getMessagePanel().getMsgOffsetLow().setMessage(String.format(LanguagePack.getTextResource().feederMsgOffsetLow(), LanguagePack.getTextResource().loadScrewOffset2(), Feeder.getWarnLowOffset().getAs(this.lengthUnit), this.view.getEditFeederPanel().getLblOffsetUnit().getText()));
    }

    private void updateMessagePanel() {
        if (this.getSelectedFeeder() == null) {
            this.view.getMessagePanel().getMsgNoFeeder().setVisible(true);
            this.view.getMessagePanel().getMsgScrewLength().setVisible(false);
            this.view.getMessagePanel().getMsgOffsetLow().setVisible(false);
            this.view.getMessagePanel().getMsgSetScrewPosition().setVisible(false);
        } else {
            this.view.getMessagePanel().getMsgNoFeeder().setVisible(false);
            this.view.getMessagePanel().getMsgScrewLength().setVisible(Compare.epsilonLessThan(this.getSelectedFeeder().getScrewLength(), Feeder.getWarnLowScrewLength()));
            this.view.getMessagePanel().getMsgSetScrewPosition().setVisible(this.getSelectedFeeder().getPose() == null);
            this.view.getMessagePanel().getMsgOffsetLow().setVisible(Compare.epsilonLessThan(this.getSelectedFeeder().getOffset(), Feeder.getWarnLowOffset()));
        }
    }

    public void updateEditFeederPanel() {
        Feeder feeder = (Feeder)this.view.getSelectorPanel().getCombo().getSelectedItem();
        if (feeder != null) {
            this.view.getEditFeederPanel().getTfScrewLength().setText(String.valueOf(feeder.getScrewLength().getAs(this.lengthUnit)));
            this.view.getEditFeederPanel().getTfOffset().setText(String.valueOf(feeder.getOffset().getAs(this.lengthUnit)));
            this.view.getEditFeederPanel().getTfSpeed().setText(String.valueOf(feeder.getSpeed().getAs(this.speedUnit)));
            this.view.getEditFeederPanel().getTfRetriesCount().setText(String.valueOf(feeder.getRetriesCount()));
            this.view.getEditFeederPanel().setVisible(true);
            this.view.getEditFeederPanel().getBtnVerifyPosition().setEnabled(feeder.getPose() != null && this.view.getEditFeederPanel().getBtnSetPosition().isEnabled());
        } else {
            this.view.getEditFeederPanel().setVisible(false);
        }
        this.updateMessagePanel();
    }

    private TextResource getTextResource() {
        return LanguagePack.getTextResource();
    }

    public UnitType getUnitType() {
        return this.apiProvider.getSystemAPI().getSystemSettings().getLocalization().getUnitType();
    }

    public void setUnits() {
        UnitType unitType = this.apiProvider.getSystemAPI().getSystemSettings().getLocalization().getUnitType();
        if (unitType.equals((Object)UnitType.METRIC)) {
            this.lengthUnit = Length.Unit.MM;
            this.speedUnit = Speed.Unit.MM_S;
        } else {
            this.lengthUnit = Length.Unit.IN;
            this.speedUnit = Speed.Unit.IN_S;
        }
    }

    public UnitsResource getUnitResource() {
        return this.languagePack.getUnitsResource();
    }

    public String getTitleText() {
        return this.getTextResource().titleInstallationFeeder();
    }

    public void initDataModel() {
    }

    public void addFeeder() {
        Feeder newFeeder = Feeder.feederFactory();
        this.feederData.saveFeeder(newFeeder);
        this.view.getSelectorPanel().getCombo().addItem(newFeeder);
        this.view.getSelectorPanel().getCombo().setSelectedItem(newFeeder);
    }

    public void editFeederName() {
        final Feeder feeder = (Feeder)this.view.getSelectorPanel().getCombo().getSelectedItem();
        if (feeder == null) {
            return;
        }
        KeyboardTextInput input = this.apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory().createStringKeyboardInput();
        input.setInitialValue(feeder.getName());
        input.show((JButton)this.view.getSelectorPanel().getBtnEdit(), (KeyboardInputCallback)new KeyboardInputCallback<String>(){

            public void onOk(String value) {
                feeder.setName(value);
                FeederContribution.this.view.getSelectorPanel().getCombo().removeItem(feeder);
                FeederContribution.this.view.getSelectorPanel().getCombo().insertItemAt(feeder, 0);
                FeederContribution.this.view.getSelectorPanel().getCombo().setSelectedItem(feeder);
                FeederContribution.this.feederData.saveFeeder(feeder);
            }
        });
    }

    public void removeFeeder() {
        Feeder feeder = this.getSelectedFeeder();
        if (feeder != null) {
            this.view.getSelectorPanel().getCombo().removeItem(feeder);
            this.feederData.removeFeeder(feeder);
            this.updateEditFeederPanel();
        }
    }

    public void selectFeeder() {
        this.updateEditFeederPanel();
    }

    public void editScrewLength() {
        final Feeder feeder = this.getSelectedFeeder();
        if (feeder == null) {
            return;
        }
        KeyboardNumberInput input = this.apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory().createDoubleKeypadInput();
        input.setInitialValue((Object)feeder.getScrewLength().getAs(this.lengthUnit));
        input.setErrorValidator((InputValidator)new InputValidator<Double>(){

            public boolean isValid(Double value) {
                Length lengthValue = FeederContribution.this.valueFactory.createLength(value.doubleValue(), FeederContribution.this.lengthUnit);
                return Feeder.screwLengthIsValid(lengthValue);
            }

            public String getMessage(Double value) {
                return String.format(LanguagePack.getTextResource().msgFloatOutOfRange(), Feeder.getMinScrewLength().getAs(FeederContribution.this.lengthUnit), Feeder.getMaxScrewLength().getAs(FeederContribution.this.lengthUnit));
            }
        });
        input.show((JTextField)this.view.getEditFeederPanel().getTfScrewLength(), (KeyboardInputCallback)new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                feeder.setScrewLength(FeederContribution.this.valueFactory.createLength(value.doubleValue(), FeederContribution.this.lengthUnit));
                FeederContribution.this.feederData.saveFeeder(feeder);
                FeederContribution.this.updateEditFeederPanel();
            }
        });
    }

    public void editOffset() {
        final Feeder feeder = this.getSelectedFeeder();
        if (feeder == null) {
            return;
        }
        KeyboardNumberInput input = this.apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory().createDoubleKeypadInput();
        input.setInitialValue((Object)feeder.getOffset().getAs(this.lengthUnit));
        input.setErrorValidator((InputValidator)new InputValidator<Double>(){

            public boolean isValid(Double value) {
                Length lengthValue = FeederContribution.this.valueFactory.createLength(value.doubleValue(), FeederContribution.this.lengthUnit);
                return Feeder.offSetIsValid(lengthValue);
            }

            public String getMessage(Double value) {
                return String.format(LanguagePack.getTextResource().msgFloatOutOfRange(), Feeder.getMinOffset().getAs(FeederContribution.this.lengthUnit), Feeder.getMaxOffset().getAs(FeederContribution.this.lengthUnit));
            }
        });
        input.show((JTextField)this.view.getEditFeederPanel().getTfOffset(), (KeyboardInputCallback)new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                feeder.setOffset(FeederContribution.this.valueFactory.createLength(value.doubleValue(), FeederContribution.this.lengthUnit));
                FeederContribution.this.feederData.saveFeeder(feeder);
                FeederContribution.this.updateEditFeederPanel();
            }
        });
    }

    public void editSpeed() {
        final Feeder feeder = this.getSelectedFeeder();
        if (feeder == null) {
            return;
        }
        KeyboardNumberInput input = this.apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory().createDoubleKeypadInput();
        input.setInitialValue((Object)feeder.getSpeed().getAs(this.speedUnit));
        input.setErrorValidator((InputValidator)new InputValidator<Double>(){

            public boolean isValid(Double value) {
                Speed speedValue = FeederContribution.this.valueFactory.createSpeed(value.doubleValue(), FeederContribution.this.speedUnit);
                return Feeder.speedIsValid(speedValue);
            }

            public String getMessage(Double value) {
                return String.format(LanguagePack.getTextResource().msgFloatOutOfRange(), Feeder.getMinSpeed().getAs(FeederContribution.this.speedUnit), Feeder.getMaxSpeed().getAs(FeederContribution.this.speedUnit));
            }
        });
        input.show((JTextField)this.view.getEditFeederPanel().getTfOffset(), (KeyboardInputCallback)new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                feeder.setSpeed(FeederContribution.this.valueFactory.createSpeed(value.doubleValue(), FeederContribution.this.speedUnit));
                FeederContribution.this.feederData.saveFeeder(feeder);
                FeederContribution.this.updateEditFeederPanel();
            }
        });
    }

    public void editRetriesCount() {
        final Feeder feeder = this.getSelectedFeeder();
        if (feeder == null) {
            return;
        }
        KeyboardNumberInput input = this.apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory().createIntegerKeypadInput();
        input.setInitialValue((Object)feeder.getRetriesCount());
        input.setErrorValidator((InputValidator)new InputValidator<Integer>(){

            public boolean isValid(Integer value) {
                return Feeder.retriesCountIsValid(value);
            }

            public String getMessage(Integer value) {
                return String.format(LanguagePack.getTextResource().msgIntegerOutOfRange(), Feeder.getMinRetriesCount(), Feeder.getMaxRetriesCount());
            }
        });
        input.show((JTextField)this.view.getEditFeederPanel().getTfRetriesCount(), (KeyboardInputCallback)new KeyboardInputCallback<Integer>(){

            public void onOk(Integer value) {
                feeder.setRetriesCount(value);
                FeederContribution.this.feederData.saveFeeder(feeder);
                FeederContribution.this.updateEditFeederPanel();
            }
        });
    }

    public void setScrewPosition() {
        final Feeder feeder = this.getSelectedFeeder();
        if (feeder == null) {
            return;
        }
        this.apiProvider.getUserInterfaceAPI().getUserInteraction().getUserDefinedRobotPosition(new RobotPositionCallback2(){

            public void onOk(PositionParameters parameters) {
                feeder.setPose(parameters.getPose());
                FeederContribution.this.feederData.saveFeeder(feeder);
                FeederContribution.this.updateEditFeederPanel();
            }
        });
    }

    public void verifyScrewPosition() {
        if (this.getSelectedFeeder() != null) {
            this.view.getLogoPanel().setVisible(false);
            this.view.getVerificationPanel().setVisible(true);
            this.view.getVerificationPanel().getBtnMoveToScrew().setEnabled(false);
            this.view.getLeftPanel().setEnabledRecursively(false);
        }
    }

    public void moveToScrew() {
        Feeder feeder = this.view.getSelectedFeeder();
        if (feeder != null && feeder.getPose() != null) {
            this.apiProvider.getUserInterfaceAPI().getUserInteraction().getRobotMovement().requestUserToMoveRobot(feeder.getPose(), new RobotMovementCallback(){

                public void onComplete(MovementCompleteEvent event) {
                }

                public void onError(MovementErrorEvent event) {
                }
            });
        }
    }

    public void moveAboveFeeder() {
        Feeder feeder = this.view.getSelectedFeeder();
        if (feeder != null && feeder.getPose() != null) {
            this.apiProvider.getUserInterfaceAPI().getUserInteraction().getRobotMovement().requestUserToMoveRobot(this.getFeederOffsetPose(feeder), new RobotMovementCallback(){

                public void onComplete(MovementCompleteEvent event) {
                    FeederContribution.this.view.getVerificationPanel().getBtnMoveToScrew().setEnabled(true);
                }

                public void onError(MovementErrorEvent event) {
                }
            });
        }
    }

    public void verificationDone() {
        this.view.getVerificationPanel().setVisible(false);
        this.view.getLogoPanel().setVisible(true);
        this.view.getLeftPanel().setEnabledRecursively(true);
        this.updateEditFeederPanel();
    }

    public Pose getFeederOffsetPose(@NotNull Feeder feeder) {
        return this.apiProvider.getInstallationAPI().getValueFactoryProvider().getPoseFactory().createPose(feeder.getPose().getPosition().getX(Length.Unit.MM), feeder.getPose().getPosition().getY(Length.Unit.MM), feeder.getPose().getPosition().getZ(Length.Unit.MM) + feeder.getOffset().getAs(Length.Unit.MM), feeder.getPose().getRotation().getRX(Angle.Unit.RAD), feeder.getPose().getRotation().getRY(Angle.Unit.RAD), feeder.getPose().getRotation().getRZ(Angle.Unit.RAD), Length.Unit.MM, Angle.Unit.RAD);
    }

    public void closeView() {
        this.saveFeederIds();
    }

    private void saveFeederIds() {
        Vector<Feeder> feeders = new Vector<Feeder>();
        for (int i = 0; i < this.view.getSelectorPanel().getCombo().getItemCount(); ++i) {
            feeders.add((Feeder)this.view.getSelectorPanel().getCombo().getItemAt(i));
        }
        this.feederData.saveFeederIds(feeders);
    }

    public Vector<Feeder> loadFeeders() {
        return this.feederData.loadFeeders();
    }

    @Nullable
    public Feeder loadFeeder(UUID id) {
        return this.feederData.loadFeeder(id.toString());
    }

    @Nullable
    private Feeder getSelectedFeeder() {
        return (Feeder)this.view.getSelectorPanel().getCombo().getSelectedItem();
    }
}

