/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.load_screw;

import com.spin.core.program_node.load_screw.LoadScrewData;
import com.spin.core.program_node.load_screw.LoadScrewText;
import com.spin.domain.ScrewFeeder;
import com.spin.util.i18n.TextResource;
import com.spin.util.script.ScriptParser;
import com.spin.util.script.ScriptUtil;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Length;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class LoadScrewScriptGenerator {
    @NotNull
    private static InputStream variableDeclarationsScript() {
        return Objects.requireNonNull(LoadScrewScriptGenerator.class.getResourceAsStream("variable_declarations.script"));
    }

    @NotNull
    private static InputStream safeApproachScript() {
        return Objects.requireNonNull(LoadScrewScriptGenerator.class.getResourceAsStream("safe_approach.script"));
    }

    @NotNull
    private static InputStream directApproachScript() {
        return Objects.requireNonNull(LoadScrewScriptGenerator.class.getResourceAsStream("direct_approach.script"));
    }

    @NotNull
    private static InputStream loadScrewScript() {
        return Objects.requireNonNull(LoadScrewScriptGenerator.class.getResourceAsStream("load_screw.script"));
    }

    @NotNull
    private static InputStream departScript() {
        return Objects.requireNonNull(LoadScrewScriptGenerator.class.getResourceAsStream("depart.script"));
    }

    void generateScript(@NotNull ScriptWriter scriptWriter, @NotNull TextResource textResource, @NotNull LoadScrewData data) {
        ScrewFeeder feeder = Objects.requireNonNull(data.selectedScrewFeeder());
        Pose feederPose = feeder.pickUpPose();
        Length screwLength = feeder.screwLength();
        String errorMessage = ScriptUtil.wrapInQuotes(textResource.load(LoadScrewText.ERROR_MESSAGE));
        String errorTitle = ScriptUtil.wrapInQuotes(textResource.load(LoadScrewText.ERROR_TITLE));
        ScriptParser parser = new ScriptParser(scriptWriter);
        parser.parseToScript(LoadScrewScriptGenerator.variableDeclarationsScript(), ScriptUtil.toScript(feederPose), Double.toString(screwLength.getAs(Length.Unit.MM)), errorMessage, errorTitle);
        parser.parseToScript(data.approachEnabled() ? LoadScrewScriptGenerator.safeApproachScript() : LoadScrewScriptGenerator.directApproachScript(), new String[0]);
        parser.parseToScript(LoadScrewScriptGenerator.loadScrewScript(), new String[0]);
        if (data.departEnabled()) {
            parser.parseToScript(LoadScrewScriptGenerator.departScript(), new String[0]);
        }
    }
}

