/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.proxy;

import com.spin.bridge_communication.proxy.BridgeProxy;
import com.spin.bridge_communication.proxy.state_machine.ConnectionEvent;
import com.spin.bridge_communication.proxy.state_machine.ConnectionStateMachine;
import com.spin.bridge_communication.proxy.xmlrpc_client.XmlRpcBridgeClient;
import com.spin.domain.RPM;
import com.ur.urcap.api.domain.value.simple.Length;
import java.net.InetAddress;
import org.apache.xmlrpc.XmlRpcException;
import org.jetbrains.annotations.NotNull;

public class BridgeProxyImpl
implements BridgeProxy {
    @NotNull
    private final XmlRpcBridgeClient bridgeClient;
    @NotNull
    private final ConnectionStateMachine stateMachine;

    BridgeProxyImpl(@NotNull XmlRpcBridgeClient bridgeClient, @NotNull ConnectionStateMachine stateMachine) {
        this.bridgeClient = bridgeClient;
        this.stateMachine = stateMachine;
    }

    @Override
    public void connectTo(@NotNull InetAddress address) {
        this.bridgeClient.setIpAddress(address);
        this.stateMachine.handleEvent(ConnectionEvent.CONNECT);
    }

    @Override
    public boolean acknowledgeErrors() {
        try {
            return this.bridgeClient.acknowledgeErrors();
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    @Override
    public boolean stopMotor() {
        try {
            return this.bridgeClient.stopMotor();
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    @Override
    public boolean startMotor(@NotNull RPM speed) {
        try {
            return this.bridgeClient.startMotor(speed.value());
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    @Override
    public boolean stopSafetyShield() {
        try {
            return this.bridgeClient.safetyShieldStop();
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    @Override
    public boolean doSafetyShieldHoming() {
        try {
            return this.bridgeClient.safetyShieldDoHoming();
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    @Override
    public boolean lockBit() {
        try {
            return this.bridgeClient.safetyShieldLockBit();
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    @Override
    public boolean releaseBit() {
        try {
            return this.bridgeClient.safetyShieldReleaseBit();
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    @Override
    public boolean coverBit() {
        try {
            return this.bridgeClient.safetyShieldCoverBit();
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    @Override
    public boolean coverScrew(Length length) {
        try {
            return this.bridgeClient.safetyShieldCoverScrew(length);
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    @Override
    public boolean moveSafetyShieldTo(Length length) {
        try {
            return this.bridgeClient.safetyShieldMoveTo(length);
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    @Override
    public boolean followRobot() {
        try {
            return this.bridgeClient.safetyShieldFollowRobot();
        }
        catch (XmlRpcException e) {
            return false;
        }
    }
}

