/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.bit_changing_station;

import com.spin.api.ExtendedInstallationAPIProvider;
import com.spin.domain.BitChangingStation;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.value.Pose;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class BitChangingStationData {
    @NotNull
    private final DataModel dataModel;
    @NotNull
    private final ExtendedInstallationAPIProvider apiProvider;

    public BitChangingStationData(@NotNull DataModel dataModel, @NotNull ExtendedInstallationAPIProvider apiProvider) {
        this.dataModel = dataModel;
        this.apiProvider = apiProvider;
    }

    @NotNull
    Set<BitChangingStation> bitChangingStations() {
        return this.loadAllIDs().stream().map(this::loadStationByID).collect(Collectors.toSet());
    }

    void storeBitChangingStation(@NotNull BitChangingStation station) {
        this.storeID(station.id());
        this.storeStation(station);
    }

    void removeBitChangingStation(@NotNull BitChangingStation station) {
        this.removeID(station.id());
        this.removeStation(station);
    }

    @NotNull
    private Collection<String> loadAllIDs() {
        String[] idLists = this.dataModel.get("id_list", new String[0]);
        return Arrays.asList(idLists);
    }

    private void storeID(@NotNull UUID id) {
        HashSet<String> ids = new HashSet<String>(this.loadAllIDs());
        ids.add(id.toString());
        this.dataModel.set("id_list", ids.toArray(new String[0]));
    }

    private void removeID(@NotNull UUID id) {
        HashSet<String> ids = new HashSet<String>(this.loadAllIDs());
        ids.remove(id.toString());
        this.dataModel.set("id_list", ids.toArray(new String[0]));
    }

    private void storeStation(@NotNull BitChangingStation station) {
        String id = station.id().toString();
        this.dataModel.set("id" + id, station.id().toString());
        this.dataModel.set("name" + id, station.name());
        this.dataModel.set("pose" + id, station.referencePose());
    }

    private void removeStation(@NotNull BitChangingStation station) {
        String id = station.id().toString();
        this.dataModel.remove("id" + id);
        this.dataModel.remove("name" + id);
        this.dataModel.remove("attempts" + id);
        this.dataModel.remove("pose" + id);
    }

    @NotNull
    private BitChangingStation loadStationByID(@NotNull String id) {
        String stationID = this.dataModel.get("id" + id, (String)null);
        String name = this.dataModel.get("name" + id, (String)null);
        Pose referencePose = this.dataModel.get("pose" + id, (Pose)null);
        assert (Stream.of(stationID, name, referencePose).noneMatch(Objects::isNull));
        return new BitChangingStation(UUID.fromString(id), name, referencePose, this.apiProvider);
    }
}

