/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.bit_changing_station;

import com.spin.api.ExtendedViewAPIProvider;
import com.spin.core.installation_node.bit_changing_station.BitChangingStationContribution;
import com.spin.core.installation_node.bit_changing_station.EditStationView;
import com.spin.core.installation_node.bit_changing_station.StationDetailsView;
import com.spin.core.installation_node.bit_changing_station.VerifyStationPositionView;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.layout.UR_MigLayout;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class BitChangingStationView
implements SwingInstallationNodeView<BitChangingStationContribution> {
    @NotNull
    private final StationDetailsView detailsView;
    @NotNull
    private final EditStationView editStationView;
    @NotNull
    private final VerifyStationPositionView verifyPositionView;
    @NotNull
    private final JPanel leftDetailsPanel;
    @NotNull
    private final JPanel rightDetailsPanel;
    @NotNull
    private final JPanel leftEditStationPanel;
    @NotNull
    private final JPanel rightEditStationPanel;
    @NotNull
    private final JPanel leftVerifyPositionPanel;
    @NotNull
    private final JPanel rightVerifyPositionPanel;

    public BitChangingStationView(@NotNull ExtendedViewAPIProvider apiProvider) {
        this.detailsView = new StationDetailsView(apiProvider);
        this.editStationView = new EditStationView(apiProvider);
        this.verifyPositionView = new VerifyStationPositionView(apiProvider);
        this.leftDetailsPanel = this.detailsView.createLeftPanel();
        this.rightDetailsPanel = this.detailsView.createRightPanel();
        this.leftEditStationPanel = this.editStationView.createLeftPanel();
        this.rightEditStationPanel = this.editStationView.createRightPanel();
        this.leftVerifyPositionPanel = this.verifyPositionView.createLeftPanel();
        this.rightVerifyPositionPanel = this.verifyPositionView.createRightPanel();
    }

    public void buildUI(@NotNull JPanel panel, @NotNull BitChangingStationContribution contribution) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 20, "[][grow]"));
        panel.add((Component)this.leftDetailsPanel, "cell 0 0, span 6 2, grow, hidemode 3");
        panel.add((Component)this.leftEditStationPanel, "cell 0 0, span 6 2, grow, hidemode 3");
        panel.add((Component)this.leftVerifyPositionPanel, "cell 0 0, span 6 2, grow, hidemode 3");
        ImagePanel spinLogo = new ImagePanel(SpinIcon.LOGO_INSTALLATION_NODE.load());
        panel.add((Component)spinLogo, "cell 6 0, span 6, right");
        panel.add((Component)this.rightDetailsPanel, "cell 6 1, span 6, grow, hidemode 3");
        panel.add((Component)this.rightEditStationPanel, "cell 6 1, span 6, grow, hidemode 3");
        panel.add((Component)this.rightVerifyPositionPanel, "cell 6 1, span 6, grow, hidemode 3");
        this.detailsView.registerListeners(contribution);
        this.editStationView.registerListeners(contribution);
        this.verifyPositionView.registerListeners(contribution);
    }

    @NotNull
    StationDetailsView getDetailsView() {
        return this.detailsView;
    }

    @NotNull
    EditStationView getEditView() {
        return this.editStationView;
    }

    @NotNull
    VerifyStationPositionView getVerifyPositionView() {
        return this.verifyPositionView;
    }

    void setActivePanel(@NotNull Panel activePanel) {
        this.leftDetailsPanel.setVisible(activePanel == Panel.DETAILS);
        this.rightDetailsPanel.setVisible(activePanel == Panel.DETAILS);
        this.leftEditStationPanel.setVisible(activePanel == Panel.EDIT_STATION);
        this.rightEditStationPanel.setVisible(activePanel == Panel.EDIT_STATION);
        this.leftVerifyPositionPanel.setVisible(activePanel == Panel.VERIFY_POSITION);
        this.rightVerifyPositionPanel.setVisible(activePanel == Panel.VERIFY_POSITION);
    }

    static enum Panel {
        DETAILS,
        EDIT_STATION,
        VERIFY_POSITION;

    }
}

