/*
 * Decompiled with CFR 0.152.
 */
package com.spin;

import com.spin.bridge_communication.proxy.BridgeProxyFactoryImpl;
import com.spin.bridge_communication.proxy.factory.ConnectionFactory;
import com.spin.core.installation_node.InstallationService;
import com.spin.core.program_node.attach_bit.AttachBitService;
import com.spin.core.program_node.detach_bit.DetachBitService;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionService;
import com.spin.core.program_node.load_screw.LoadScrewService;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupService;
import com.spin.core.program_node.screwdriving_setup.drive_screw.DriveScrewService;
import com.spin.core.program_node.screwdriving_setup.on_fault.OnFaultService;
import com.spin.core.program_node.screwdriving_setup.on_success.OnSuccessService;
import com.spin.core.program_node.tool_action.ToolActionService;
import com.spin.core.toolbar.ToolbarService;
import com.spin.util.SpinLog;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeService;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeService;
import com.ur.urcap.api.contribution.toolbar.swing.SwingToolbarService;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static void configureLogging() {
        if (Activator.isURSimContainer()) {
            SpinLog.setLogFile(new File("/urcaps/spin.log"));
        }
    }

    private static boolean isURSimContainer() {
        return "ursim_container".equals(System.getenv("HOSTNAME"));
    }

    public void start(@NotNull BundleContext context) {
        Activator.configureLogging();
        BridgeProxyFactoryImpl bridgeProxyFactory = new BridgeProxyFactoryImpl(new ConnectionFactory());
        context.registerService(SwingInstallationNodeService.class, (Object)new InstallationService(bridgeProxyFactory), null);
        context.registerService(SwingProgramNodeService.class, (Object)new ScrewdrivingSetupService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new AttachBitService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new DetachBitService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new ToolActionService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new LoadScrewService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new DriveScrewService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new OnSuccessService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new OnFaultService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new MoveDirectionService(), null);
        context.registerService(SwingToolbarService.class, (Object)new ToolbarService(), null);
    }

    public void stop(@NotNull BundleContext bundleContext) {
    }
}

