/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.detach_bit;

import com.spin.core.program_node.detach_bit.DetachBitData;
import com.spin.core.program_node.detach_bit.DetachBitText;
import com.spin.domain.BitChangingStation;
import com.spin.i18n.TextResource;
import com.spin.script.ScriptParser;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DetachBitScriptGenerator {
    void generateScript(@NotNull ScriptWriter writer, @NotNull TextResource textResource, @NotNull DetachBitData data) {
        BitChangingStation.Bit bit = data.selectedBit();
        BitChangingStation station = data.selectedStation();
        Pose bitPose = station.poseOf(bit);
        Pose poseInFront = station.poseInFrontOf(bit);
        Pose endSafePose = station.poseEndSafe(bit);
        InputStream detachBitScript = Objects.requireNonNull(this.getClass().getResourceAsStream("DetachBit.script"));
        ScriptParser parser = new ScriptParser(writer);
        parser.parseToScript(detachBitScript, this.poseToScriptString(bitPose), this.poseToScriptString(poseInFront), this.poseToScriptString(endSafePose), "\"" + textResource.load(DetachBitText.ERROR_MESSAGE) + "\"", "\"" + textResource.load(DetachBitText.ERROR_TITLE) + "\"", this.boolToString(data.approachEnabled()));
    }

    private String poseToScriptString(@NotNull Pose pose) {
        double[] values = pose.toArray(Length.Unit.M, Angle.Unit.RAD);
        assert (values.length == 6);
        return String.format("p[%f, %f, %f, %f, %f, %f]", values[0], values[1], values[2], values[3], values[4], values[5]);
    }

    private String boolToString(@NotNull Boolean bool) {
        return bool != false ? "True" : "False";
    }
}

