/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup;

import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupData;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupText;
import com.spin.domain.Program;
import com.spin.util.i18n.TextResource;
import com.spin.util.script.ScriptParser;
import com.spin.util.script.ScriptUtil;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DriveScrewScriptGenerator {
    @NotNull
    private final TextResource textResource;

    public DriveScrewScriptGenerator(@NotNull TextResource textResource) {
        this.textResource = textResource;
    }

    @NotNull
    private static InputStream initializationScript() {
        return Objects.requireNonNull(DriveScrewScriptGenerator.class.getResourceAsStream("initialization.script"));
    }

    @NotNull
    private static InputStream safeApproachScript() {
        return Objects.requireNonNull(DriveScrewScriptGenerator.class.getResourceAsStream("safe_approach.script"));
    }

    @NotNull
    private static InputStream directApproachScript() {
        return Objects.requireNonNull(DriveScrewScriptGenerator.class.getResourceAsStream("direct_approach.script"));
    }

    @NotNull
    private static InputStream screwProcessScript() {
        return Objects.requireNonNull(DriveScrewScriptGenerator.class.getResourceAsStream("screw_process.script"));
    }

    public void generateScript(@NotNull ScriptWriter scriptWriter, @NotNull ScrewdrivingSetupData data) {
        Program program = Objects.requireNonNull(data.selectedProgram());
        boolean useSafeApproach = data.approachIsEnabled();
        String refPoseExpression = data.useSpinTarget() ? scriptWriter.getResolvedVariableName(data.spinTargetVariable()) : ScriptUtil.toScript(Objects.requireNonNull(data.screwPose()));
        ScriptParser parser = new ScriptParser(scriptWriter);
        this.generateProgramScript(parser, program, refPoseExpression, useSafeApproach);
    }

    private void generateProgramScript(@NotNull ScriptParser parser, @NotNull Program program, @NotNull String refPoseExpression, boolean useSafeApproach) {
        String errorPopupTitle = this.textResource.load(ScrewdrivingSetupText.ERROR_TITLE);
        parser.parseToScript(DriveScrewScriptGenerator.initializationScript(), refPoseExpression, Double.toString(program.reference_depth().getAs(Length.Unit.M)), Double.toString(program.start_depth().getAs(Length.Unit.M)), errorPopupTitle);
        if (useSafeApproach) {
            parser.parseToScript(DriveScrewScriptGenerator.safeApproachScript(), Double.toString(program.inital_safety_shield_position().getAs(Length.Unit.MM)), this.textResource.load(ScrewdrivingSetupText.ERROR_APPROACH_FAILED), errorPopupTitle);
        } else {
            parser.parseToScript(DriveScrewScriptGenerator.directApproachScript(), Double.toString(program.inital_safety_shield_position().getAs(Length.Unit.MM)));
        }
        parser.parseToScript(DriveScrewScriptGenerator.screwProcessScript(), program.uuid().toString(), Double.toString(program.driving_force().getAs(Force.Unit.N)));
    }
}

