/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node;

import com.spin.api.ExtendedInstallationAPIProvider;
import com.spin.core.installation_node.bit_changing_station.BitChangingStationData;
import com.spin.core.installation_node.bridge_tool.BridgeAndToolData;
import com.spin.core.installation_node.screw_feeder.ScrewFeederData;
import com.spin.model.PrefixedDataModel;
import com.ur.urcap.api.domain.data.DataModel;
import org.jetbrains.annotations.NotNull;

public class InstallationData {
    @NotNull
    private final BridgeAndToolData bridgeAndToolData;
    @NotNull
    private final ScrewFeederData screwFeederData;
    @NotNull
    private final BitChangingStationData bitChangingStationData;

    InstallationData(@NotNull DataModel model, @NotNull ExtendedInstallationAPIProvider apiProvider) {
        this.bridgeAndToolData = new BridgeAndToolData(new PrefixedDataModel(model, "bridge"));
        this.screwFeederData = new ScrewFeederData(new PrefixedDataModel(model, "screw"), apiProvider);
        this.bitChangingStationData = new BitChangingStationData(new PrefixedDataModel(model, "bit"), apiProvider);
    }

    @NotNull
    BridgeAndToolData getBridgeAndToolData() {
        return this.bridgeAndToolData;
    }

    @NotNull
    ScrewFeederData getScrewFeederData() {
        return this.screwFeederData;
    }

    @NotNull
    BitChangingStationData getBitChangingStationData() {
        return this.bitChangingStationData;
    }
}

