/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.program_nodes;

import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.localization.TextResource;
import com.spin.urcap.impl.program_nodes.ExtractScrewProgramNodeContribution;
import com.spin.urcap.impl.util.ImageHelper;
import com.spin.urcap.impl.util.PopupTool;
import com.spin.urcap.impl.util.Product;
import com.spin.urcap.impl.util.ScrewProgram;
import com.spin.urcap.impl.util.swing.SwingAbstractStyle;
import com.spin.urcap.impl.util.swing.SwingStandards;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractScrewProgramNodeView
implements SwingProgramNodeView<ExtractScrewProgramNodeContribution> {
    private final JLabel forceInTCPZLabel = new JLabel();
    private final JLabel forceInTCPZUnitLabel = new JLabel();
    private final JTextField forceInTCPZ = new JTextField();
    private final JTextField s1Offset = new JTextField();
    private final JTextField s2Offset = new JTextField();
    private final JTextField maxVelocity = new JTextField();
    private final JLabel drawing = new JLabel();
    private final JLabel maxVelocityLabel = new JLabel();
    private final JLabel maxVelocityUnitLabel = new JLabel();
    private final JLabel s1offSetUnitLabel = new JLabel();
    private final JLabel s1offSetLabel = new JLabel();
    private final JLabel s2offSetUnitLabel = new JLabel();
    private final JLabel s2offSetLabel = new JLabel();
    private final JLabel S1;
    private final JLabel S2;
    private final SwingAbstractStyle style;
    private final JLabel safetyWarningLabel = new JLabel();
    private JButton setPoseBtn;
    private JButton moveHereBtn;
    private JButton infoBtn;
    private JPanel safetyPanel;
    private JPanel jPanel;
    private JPanel mainPanel;
    private JPanel bottomPanel;
    private JPanel infoPanel;
    private JCheckBox enableSafetyCheckBox;
    private JCheckBox externalTargetCheckBox;
    private boolean enableSafety = true;
    private JComboBox<Product> productComboBox;
    private JComboBox<ScrewProgram> screwProgramComboBox;

    public ExtractScrewProgramNodeView(SwingAbstractStyle style) {
        this.style = style;
        this.S1 = ImageHelper.loadImage("/com/spin/urcap/icons/offsetS1.jpg");
        this.S2 = ImageHelper.loadImage("/com/spin/urcap/icons/offsetS2.jpg");
    }

    public void buildUI(@NotNull JPanel jPanel, final @NotNull ContributionProvider<ExtractScrewProgramNodeContribution> contributionProvider) {
        this.jPanel = jPanel;
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        this.mainPanel = new JPanel();
        this.bottomPanel = new JPanel(new BorderLayout());
        GroupLayout layout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        this.drawing.setIcon(this.S1.getIcon());
        JSeparator sep = new JSeparator(0);
        JSeparator sep2 = new JSeparator(0);
        Component productCB = this.createProductComboBox(contributionProvider);
        Component screwProgramCB = this.createScrewProgramComboBox(contributionProvider);
        this.createInfoButton();
        this.createInfoPanel();
        JLabel productLabel = new JLabel(this.getTextResource().extractScrewProduct());
        productLabel.setFont(productLabel.getFont().deriveFont(1));
        JLabel screwLabel = new JLabel(this.getTextResource().extractScrewScrew());
        screwLabel.setFont(screwLabel.getFont().deriveFont(1));
        this.setPoseBtn(contributionProvider);
        this.moveHereBtn(contributionProvider);
        JLabel rowSeparator = new JLabel("");
        rowSeparator.setPreferredSize(new Dimension(100, 5));
        this.createExternalTargetCheckBox(contributionProvider);
        Box s1Component = this.createLabelInputField(this.s1offSetLabel, this.s1offSetUnitLabel, this.s1Offset, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyboardNumberInput<Double> keyboardInput = ((ExtractScrewProgramNodeContribution)contributionProvider.get()).getKeyboardForS1();
                keyboardInput.show(ExtractScrewProgramNodeView.this.s1Offset, ((ExtractScrewProgramNodeContribution)contributionProvider.get()).getCallbackForS1());
                ExtractScrewProgramNodeView.this.drawing.setIcon(ExtractScrewProgramNodeView.this.S1.getIcon());
            }
        });
        Box s2Component = this.createLabelInputField(this.s2offSetLabel, this.s2offSetUnitLabel, this.s2Offset, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyboardNumberInput<Double> keyboardInput = ((ExtractScrewProgramNodeContribution)contributionProvider.get()).getKeyboardForS2();
                keyboardInput.show(ExtractScrewProgramNodeView.this.s2Offset, ((ExtractScrewProgramNodeContribution)contributionProvider.get()).getCallbackForS2());
                ExtractScrewProgramNodeView.this.drawing.setIcon(ExtractScrewProgramNodeView.this.S2.getIcon());
            }
        });
        Box velocityComponent = this.createLabelInputField(this.maxVelocityLabel, this.maxVelocityUnitLabel, this.maxVelocity, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyboardNumberInput<Double> keyboardInput = ((ExtractScrewProgramNodeContribution)contributionProvider.get()).getKeyboardVelocity();
                keyboardInput.show(ExtractScrewProgramNodeView.this.s2Offset, ((ExtractScrewProgramNodeContribution)contributionProvider.get()).getCallbackVelocity());
            }
        });
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(s1Component, -2, -2, -2).addComponent(s2Component, -2, -2, -2).addComponent(velocityComponent, -2, -2, -2).addComponent(sep, -2, -2, Short.MAX_VALUE).addComponent(productLabel, -2, -2, Short.MAX_VALUE).addComponent(productCB, -2, -2, Short.MAX_VALUE).addComponent(screwLabel, -2, -2, Short.MAX_VALUE).addComponent(screwProgramCB, -2, -2, Short.MAX_VALUE).addComponent(this.setPoseBtn, -2, -2, Short.MAX_VALUE).addComponent(this.moveHereBtn, -2, -2, Short.MAX_VALUE).addComponent(sep2, -2, -2, Short.MAX_VALUE).addComponent(this.externalTargetCheckBox, -2, -2, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(rowSeparator, -2, -2, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.infoBtn, -2, -2, -2).addComponent(this.drawing, -2, -2, Short.MAX_VALUE).addGap(2 * this.style.getURComponentHeightDefault())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(s1Component, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(s2Component, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(velocityComponent, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(sep, -2, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(productLabel, -2, -2, Short.MAX_VALUE).addComponent(productCB, -2, -2, Short.MAX_VALUE).addComponent(screwLabel, -2, -2, Short.MAX_VALUE).addComponent(screwProgramCB, -2, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.setPoseBtn, -2, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.moveHereBtn, -2, -2, Short.MAX_VALUE).addGap(this.style.getVerticalSmallSpacing()).addComponent(sep2, -2, -2, Short.MAX_VALUE).addGap(this.style.getVerticalLargeSpacing()).addComponent(this.externalTargetCheckBox, -2, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(rowSeparator, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.infoBtn, -2, -2, -2).addComponent(this.drawing, -2, -2, Short.MAX_VALUE)));
        this.createSafetyPanel(contributionProvider);
        JLabel logoLabel = this.createLogo();
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.setAlignmentX(0.0f);
        horizontalBox.add(logoLabel);
        horizontalBox.add(Box.createHorizontalGlue());
        horizontalBox.add(this.safetyPanel);
        Box verticalBox = Box.createVerticalBox();
        verticalBox.setAlignmentX(0.0f);
        verticalBox.setAlignmentY(0.0f);
        verticalBox.add(Box.createVerticalStrut(5));
        verticalBox.add(horizontalBox);
        this.bottomPanel.add((Component)verticalBox, "Last");
        jPanel.add(this.mainPanel);
        jPanel.add(this.bottomPanel);
    }

    @NotNull
    private Box createLabelInputField(@NotNull JLabel label, @NotNull JLabel unit, @NotNull JTextField inputField, MouseAdapter mouseAdapter) {
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.setAlignmentX(0.0f);
        label.setHorizontalAlignment(2);
        Dimension d = new Dimension(150, 5);
        label.setPreferredSize(d);
        label.setSize(d);
        unit.setHorizontalAlignment(4);
        inputField.setFocusable(false);
        inputField.setPreferredSize(new Dimension(100, 30));
        inputField.setMaximumSize(inputField.getPreferredSize());
        inputField.addMouseListener(mouseAdapter);
        horizontalBox.add(label);
        horizontalBox.add(Box.createHorizontalGlue());
        horizontalBox.add(inputField);
        horizontalBox.add(Box.createRigidArea(new Dimension(5, 0)));
        horizontalBox.add(unit);
        return horizontalBox;
    }

    private void createSafetyPanel(final ContributionProvider<ExtractScrewProgramNodeContribution> contributionProvider) {
        this.safetyPanel = new JPanel();
        this.safetyPanel.setBorder(this.style.getDefaultBtnBoarder());
        GroupLayout layout = new GroupLayout(this.safetyPanel);
        this.safetyPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        this.safetyWarningLabel.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/placeholder_large.png"))));
        this.safetyWarningLabel.setHorizontalAlignment(0);
        this.safetyWarningLabel.setVerticalAlignment(0);
        Box forceInTCPZComponent = this.createLabelInputField(this.forceInTCPZLabel, this.forceInTCPZUnitLabel, this.forceInTCPZ, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyboardNumberInput<Double> keyboardInput = ((ExtractScrewProgramNodeContribution)contributionProvider.get()).getKeyboardForForceInTCPZ();
                keyboardInput.show(ExtractScrewProgramNodeView.this.forceInTCPZ, ((ExtractScrewProgramNodeContribution)contributionProvider.get()).getCallbackForForceInTCPZ());
            }
        });
        this.enableSafetyCheckBox = SwingStandards.createCheckBox(this.getTextResource().softSafetyEnable(), 10, this.style.getCheckBoxSize(), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExtractScrewProgramNodeView.this.enableSafetyCheckBox.isSelected()) {
                    ExtractScrewProgramNodeView.this.enableSafety = true;
                    ExtractScrewProgramNodeView.this.safetyWarningLabel.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/placeholder_large.png"))));
                    ExtractScrewProgramNodeView.this.forceInTCPZ.setEnabled(true);
                    ExtractScrewProgramNodeView.this.forceInTCPZ.setEditable(true);
                    ExtractScrewProgramNodeView.this.forceInTCPZLabel.setEnabled(true);
                    ExtractScrewProgramNodeView.this.forceInTCPZUnitLabel.setEnabled(true);
                    ExtractScrewProgramNodeView.this.enableSafetyCheckBox.setBackground(SwingAbstractStyle.URColor.UR_WHITE);
                    ExtractScrewProgramNodeView.this.safetyPanel.setBackground(SwingAbstractStyle.URColor.UR_WHITE);
                } else if (PopupTool.showDialogOptionWarning(ExtractScrewProgramNodeView.this.getTextResource().softSafetyPopupText(), ExtractScrewProgramNodeView.this.getTextResource().softSafetyPopupTitle(), ExtractScrewProgramNodeView.this.getTextResource().optionYes(), ExtractScrewProgramNodeView.this.getTextResource().optionNo(), new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png")))) > 0) {
                    ExtractScrewProgramNodeView.this.enableSafetyCheckBox.setSelected(true);
                } else {
                    ExtractScrewProgramNodeView.this.enableSafety = false;
                    ExtractScrewProgramNodeView.this.safetyWarningLabel.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_large.png"))));
                    ExtractScrewProgramNodeView.this.forceInTCPZ.setEnabled(false);
                    ExtractScrewProgramNodeView.this.forceInTCPZ.setEditable(false);
                    ExtractScrewProgramNodeView.this.forceInTCPZLabel.setEnabled(false);
                    ExtractScrewProgramNodeView.this.forceInTCPZUnitLabel.setEnabled(false);
                    ExtractScrewProgramNodeView.this.enableSafetyCheckBox.setBackground(SwingAbstractStyle.URColor.UR_YELLOW);
                    ExtractScrewProgramNodeView.this.safetyPanel.setBackground(SwingAbstractStyle.URColor.UR_YELLOW);
                }
                ((ExtractScrewProgramNodeContribution)contributionProvider.get()).safetySettingsChanged(ExtractScrewProgramNodeView.this.enableSafetyCheckBox.isSelected());
            }
        });
        this.enableSafetyCheckBox.setSelected(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enableSafetyCheckBox, -2, -2, Short.MAX_VALUE).addComponent(forceInTCPZComponent, -2, -2, Short.MAX_VALUE)).addComponent(this.safetyWarningLabel, -2, -2, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(this.enableSafetyCheckBox, -2, -2, Short.MAX_VALUE).addComponent(forceInTCPZComponent, -2, -2, Short.MAX_VALUE)).addComponent(this.safetyWarningLabel, -2, -2, Short.MAX_VALUE)));
    }

    private Component createProductComboBox(final ContributionProvider<ExtractScrewProgramNodeContribution> contributionProvider) {
        Product[] refProducts = new Product[]{new Product(this.getTextResource().extractScrewSelectProduct())};
        this.productComboBox = new JComboBox<Product>(refProducts);
        this.productComboBox.setFocusable(false);
        this.productComboBox.setPreferredSize(this.style.getComboBoxSize());
        this.productComboBox.setMaximumSize(this.productComboBox.getPreferredSize());
        this.productComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Product selectedProduct = (Product)ExtractScrewProgramNodeView.this.productComboBox.getSelectedItem();
                if (selectedProduct != null && !selectedProduct.name.equals(ExtractScrewProgramNodeView.this.getTextResource().extractScrewSelectProduct())) {
                    ((ExtractScrewProgramNodeContribution)contributionProvider.get()).setSelectedProduct(selectedProduct);
                    ((ExtractScrewProgramNodeContribution)contributionProvider.get()).updateScrewProgramComboBox();
                }
            }
        });
        return this.productComboBox;
    }

    public void updateProductComboBox(@NotNull Product[] products) {
        this.productComboBox.removeAllItems();
        this.productComboBox.addItem(new Product(this.getTextResource().extractScrewSelectProduct()));
        for (Product product : products) {
            this.productComboBox.addItem(product);
        }
    }

    public void setSelectedProduct(Product selectedProduct) {
        if (selectedProduct != null) {
            this.productComboBox.setSelectedItem(selectedProduct);
        }
    }

    private Component createScrewProgramComboBox(final ContributionProvider<ExtractScrewProgramNodeContribution> contributionProvider) {
        ScrewProgram[] refScrewPrograms = new ScrewProgram[]{new ScrewProgram(this.getTextResource().extractScrewSelectScrewProgram())};
        this.screwProgramComboBox = new JComboBox<ScrewProgram>(refScrewPrograms);
        this.screwProgramComboBox.setFocusable(false);
        this.screwProgramComboBox.setPreferredSize(this.style.getComboBoxSize());
        this.screwProgramComboBox.setMaximumSize(this.screwProgramComboBox.getPreferredSize());
        this.screwProgramComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrewProgram selectedScrewProgram = (ScrewProgram)ExtractScrewProgramNodeView.this.screwProgramComboBox.getSelectedItem();
                if (selectedScrewProgram != null && !selectedScrewProgram.name.equals(ExtractScrewProgramNodeView.this.getTextResource().extractScrewSelectScrewProgram())) {
                    ((ExtractScrewProgramNodeContribution)contributionProvider.get()).setSelectedScrewProgram(selectedScrewProgram);
                }
            }
        });
        return this.screwProgramComboBox;
    }

    public void updateScrewProgramComboBox(@NotNull ScrewProgram[] screwPrograms) {
        this.screwProgramComboBox.removeAllItems();
        this.screwProgramComboBox.addItem(new ScrewProgram(this.getTextResource().extractScrewSelectScrewProgram()));
        for (ScrewProgram screwProgram : screwPrograms) {
            this.screwProgramComboBox.addItem(screwProgram);
        }
    }

    public void setSelectedScrewProgram(@Nullable ScrewProgram selectedScrewProgram) {
        if (selectedScrewProgram != null) {
            this.screwProgramComboBox.setSelectedItem(selectedScrewProgram);
        }
    }

    private void setPoseBtn(final ContributionProvider<ExtractScrewProgramNodeContribution> provider) {
        this.setPoseBtn = new JButton();
        this.setPoseBtn.setPreferredSize(this.style.getButtonSizeDefault());
        this.setPoseBtn.setMaximumSize(this.style.getButtonSizeLarge());
        this.setPoseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((ExtractScrewProgramNodeContribution)provider.get()).selectPose();
            }
        });
    }

    private void moveHereBtn(final ContributionProvider<ExtractScrewProgramNodeContribution> provider) {
        this.moveHereBtn = new JButton();
        this.moveHereBtn.setPreferredSize(this.style.getButtonSizeDefault());
        this.moveHereBtn.setMaximumSize(this.style.getButtonSizeLarge());
        this.moveHereBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((ExtractScrewProgramNodeContribution)provider.get()).moveRobot();
            }
        });
    }

    private void createInfoButton() {
        this.infoBtn = new JButton();
        try {
            BufferedImage image = ImageHelper.read("/com/spin/urcap/icons/UR_e-Series_1.0/information_icon.png");
            this.infoBtn.setIcon(new ImageIcon(image));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.infoBtn.setPreferredSize(new Dimension(35, 35));
        this.infoBtn.setMaximumSize(this.infoBtn.getPreferredSize());
        this.infoBtn.setBorderPainted(false);
        this.infoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractScrewProgramNodeView.this.mainPanel.setVisible(false);
                ExtractScrewProgramNodeView.this.bottomPanel.setVisible(false);
                ExtractScrewProgramNodeView.this.jPanel.remove(ExtractScrewProgramNodeView.this.mainPanel);
                ExtractScrewProgramNodeView.this.jPanel.remove(ExtractScrewProgramNodeView.this.bottomPanel);
                ExtractScrewProgramNodeView.this.jPanel.add(ExtractScrewProgramNodeView.this.infoPanel);
                ExtractScrewProgramNodeView.this.infoPanel.setVisible(true);
            }
        });
    }

    private void createInfoPanel() {
        this.infoPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(layout);
        JLabel lblInfoTitle = SwingStandards.createLabel(this.getTextResource().extractScrewInfoTitle(), true, false, new Dimension(450, 50), this.style.getURFontSizeMainHeading());
        JTextArea lblInfoDescription = this.createInfoText(this.getTextResource().extractScrewInfoDescription());
        JButton returnBtn = new JButton(this.getTextResource().optionReturn());
        returnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractScrewProgramNodeView.this.setPanelsVisible();
            }
        });
        JLabel logo = this.createLogo();
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(lblInfoTitle, -2, -2, -2).addComponent(lblInfoDescription, -2, -2, -2).addComponent(returnBtn, -2, -2, -2).addComponent(logo, -2, -2, -2)).addGroup(layout.createParallelGroup().addGap(this.style.getHorizontalLargeSpacing() * 5)).addGroup(layout.createParallelGroup()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(lblInfoTitle, -2, -2, -2).addComponent(lblInfoDescription, -2, -2, -2).addComponent(returnBtn, -2, -2, -2).addGap(this.style.getVerticalLargeSpacing() * 9).addComponent(logo, -2, -2, -2)).addGroup(layout.createSequentialGroup()).addGroup(layout.createSequentialGroup()));
    }

    public void setPanelsVisible() {
        this.infoPanel.setVisible(false);
        this.jPanel.remove(this.infoPanel);
        this.jPanel.add(this.mainPanel);
        this.jPanel.add(this.bottomPanel);
        this.mainPanel.setVisible(true);
        this.bottomPanel.setVisible(true);
    }

    @NotNull
    private JTextArea createInfoText(@Nullable String text) {
        JTextArea info = new JTextArea();
        info.setText(text);
        info.setLineWrap(true);
        info.setPreferredSize(new Dimension(650, 110));
        info.setMaximumSize(info.getPreferredSize());
        info.setEditable(false);
        info.setWrapStyleWord(true);
        info.setFont(new Font(info.getFont().getFontName(), this.style.getUrFontStylePlain(), this.style.getUrFontSizeDefault()));
        return info;
    }

    private void createExternalTargetCheckBox(final @NotNull ContributionProvider<ExtractScrewProgramNodeContribution> contributionProvider) {
        this.externalTargetCheckBox = SwingStandards.createCheckBox(this.getTextResource().extractScrewVariableTargetText(), 10, this.style.getCheckBoxSize(), false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExtractScrewProgramNodeView.this.externalTargetCheckBox.isSelected()) {
                    ExtractScrewProgramNodeView.this.setPoseBtn.setEnabled(false);
                    ExtractScrewProgramNodeView.this.moveHereBtn.setEnabled(false);
                    ((ExtractScrewProgramNodeContribution)contributionProvider.get()).setCheckBoxExternalTarget(true);
                } else {
                    ExtractScrewProgramNodeView.this.setPoseBtn.setEnabled(true);
                    ExtractScrewProgramNodeView.this.moveHereBtn.setEnabled(((ExtractScrewProgramNodeContribution)contributionProvider.get()).model.get("KEY_BUTTON_VERIFY_INSERTION_POSITION_ENABLED", false));
                    ((ExtractScrewProgramNodeContribution)contributionProvider.get()).setCheckBoxExternalTarget(false);
                }
            }
        });
    }

    private TextResource getTextResource() {
        return LanguagePack.getTextResource();
    }

    public void setForceInTCPZLabel(String data) {
        this.forceInTCPZLabel.setText(data);
    }

    public void setForceInTCPZUnitLabel(String data) {
        this.forceInTCPZUnitLabel.setText(data);
    }

    public String getForceInTCPZ() {
        return this.forceInTCPZ.getText();
    }

    public void setForceInTCPZ(String data) {
        this.forceInTCPZ.setText(data);
    }

    public boolean getEnableSafety() {
        return this.enableSafety;
    }

    public void setSetPoseBtn(String data) {
        this.setPoseBtn.setText(data);
    }

    public void setMoveHereBtnText(String data) {
        this.moveHereBtn.setText(data);
    }

    public void enableMoveBtn(boolean bool) {
        this.moveHereBtn.setEnabled(bool);
    }

    public void enableSetPoseBtn(boolean bool) {
        this.setPoseBtn.setEnabled(bool);
    }

    public void setS1OffsetIconWarning() {
        this.s1offSetLabel.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png"))));
    }

    public void setS1OffsetIconNoWarning() {
        this.s1offSetLabel.setIcon(null);
    }

    public void setS1OffSetLabel(@Nullable String data) {
        this.s1offSetLabel.setText(data);
    }

    public void setS1OffSetUnitLabel(@Nullable String data) {
        this.s1offSetUnitLabel.setText(data);
    }

    public void setS2offSetLabel(@Nullable String data) {
        this.s2offSetLabel.setText(data);
    }

    public void setS2offSetUnitLabel(@Nullable String data) {
        this.s2offSetUnitLabel.setText(data);
    }

    public void setMaxVelocityLabel(@Nullable String data) {
        this.maxVelocityLabel.setText(data);
    }

    public void setMaxVelocityUnitLabel(@Nullable String data) {
        this.maxVelocityUnitLabel.setText(data);
    }

    public void setMaxVelocity(@Nullable String data) {
        this.maxVelocity.setText(data);
    }

    public void setExternalTargetCheckBox(boolean bool) {
        this.externalTargetCheckBox.setSelected(bool);
    }

    public String getS1Offset() {
        return this.s1Offset.getText();
    }

    public void setS1Offset(String data) {
        this.s1Offset.setText(data);
    }

    public String getS2Offset() {
        return this.s2Offset.getText();
    }

    public void setS2Offset(String data) {
        this.s2Offset.setText(data);
    }

    @NotNull
    private JLabel createLogo() {
        JLabel drawing = new JLabel();
        drawing.setHorizontalAlignment(4);
        drawing.setVerticalAlignment(1);
        drawing.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/SR_logo200x50.jpg"))));
        drawing.setSize(this.style.getDefaultLogoSize());
        return drawing;
    }
}

