/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.unit;

import com.spin.ui.unit.UnitConverter;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.api.domain.value.simple.Torque;
import org.jetbrains.annotations.NotNull;

public class ImperialConverter
extends UnitConverter {
    @NotNull
    private final SimpleValueFactory valueFactory;

    ImperialConverter(@NotNull SimpleValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    @Override
    @NotNull
    public String lengthLabel() {
        return "in";
    }

    @Override
    @NotNull
    public String forceLabel() {
        return "lbf";
    }

    @Override
    @NotNull
    public String massLabel() {
        return "lb";
    }

    @Override
    @NotNull
    public String speedLabel() {
        return "in/s";
    }

    @Override
    @NotNull
    public String torqueLabel() {
        return "lb-ft";
    }

    @Override
    @NotNull
    public String angleLabel() {
        return "\u00b0";
    }

    @Override
    public double valueOf(@NotNull Length length) {
        return length.getAs(Length.Unit.IN);
    }

    @Override
    public double valueOf(@NotNull Force force) {
        return force.getAs(Force.Unit.LBF);
    }

    @Override
    public double valueOf(@NotNull Mass mass) {
        return mass.getAs(Mass.Unit.LB);
    }

    @Override
    public double valueOf(@NotNull Speed speed) {
        return speed.getAs(Speed.Unit.IN_S);
    }

    @Override
    public double valueOf(@NotNull Torque torque) {
        return torque.getAs(Torque.Unit.LBFT);
    }

    @Override
    public double valueOf(@NotNull Angle angle) {
        return angle.getAs(Angle.Unit.DEG);
    }

    @Override
    @NotNull
    protected Length asLength(double value) {
        return this.valueFactory.createLength(value, Length.Unit.IN);
    }

    @Override
    @NotNull
    protected Force asForce(double value) {
        return this.valueFactory.createForce(value, Force.Unit.LBF);
    }

    @Override
    @NotNull
    protected Mass asMass(double value) {
        return this.valueFactory.createMass(value, Mass.Unit.LB);
    }

    @Override
    @NotNull
    protected Speed asSpeed(double value) {
        return this.valueFactory.createSpeed(value, Speed.Unit.IN_S);
    }

    @Override
    @NotNull
    protected Torque asTorque(double value) {
        return this.valueFactory.createTorque(value, Torque.Unit.LBFT);
    }

    @Override
    @NotNull
    protected Angle asAngle(double value) {
        return this.valueFactory.createAngle(value, Angle.Unit.DEG);
    }
}

