/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.detach_bit;

import com.spin.core.installation_node.InstallationContribution;
import com.spin.domain.BitChangingStation;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetachBitData {
    @NotNull
    private final DataModel dataModel;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final InstallationContribution installationContribution;

    DetachBitData(@NotNull DataModel dataModel, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.dataModel = dataModel;
        this.undoRedoManager = apiProvider.getProgramAPIProvider().getProgramAPI().getUndoRedoManager();
        this.installationContribution = (InstallationContribution)apiProvider.getProgramAPIProvider().getProgramAPI().getInstallationNode(InstallationContribution.class);
    }

    @NotNull
    Set<BitChangingStation> bitChangingStations() {
        return this.installationContribution.getBitChangingStations();
    }

    @Nullable
    BitChangingStation.Bit selectedBit() {
        int selectedOrdinal = this.dataModel.get("bit", -1);
        return selectedOrdinal == -1 ? null : BitChangingStation.Bit.values()[selectedOrdinal];
    }

    void setSelectedBit(@NotNull BitChangingStation.Bit bit) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("bit", bit.ordinal()));
    }

    @Nullable
    BitChangingStation selectedStation() {
        Set<BitChangingStation> bitChangingStations = this.installationContribution.getBitChangingStations();
        String stringUUID = this.dataModel.get("station", (String)null);
        if (stringUUID == null) {
            return null;
        }
        UUID uuid = UUID.fromString(stringUUID);
        return bitChangingStations.stream().filter(station -> station.id().equals(uuid)).findFirst().orElse(null);
    }

    void setSelectedStation(@NotNull BitChangingStation station) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("station", station.id().toString()));
    }

    boolean approachEnabled() {
        return this.dataModel.get("approachEnabled", true);
    }

    void setApproachEnabled(boolean enabled) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("approachEnabled", enabled));
    }

    boolean isValidConfiguration() {
        return this.selectedBit() != null && this.selectedStation() != null;
    }
}

