/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup;

import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupData;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupText;
import com.spin.domain.Program;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.api.NodeFactory;
import com.spin.util.i18n.TextResource;
import com.spin.util.script.ScriptParser;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Length;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DriveScrewScriptGenerator {
    @NotNull
    private final TextResource textResource;

    public DriveScrewScriptGenerator(@NotNull TextResource textResource) {
        this.textResource = textResource;
    }

    @NotNull
    private static InputStream initializationScript() {
        return Objects.requireNonNull(DriveScrewScriptGenerator.class.getResourceAsStream("initialization.script"));
    }

    @NotNull
    private static InputStream screwProcessScriptWithForceControl() {
        return Objects.requireNonNull(DriveScrewScriptGenerator.class.getResourceAsStream("screw_process.script"));
    }

    @NotNull
    private static InputStream screwProcessScriptWithSpeedControl() {
        return Objects.requireNonNull(DriveScrewScriptGenerator.class.getResourceAsStream("screw_process_speed_control.script"));
    }

    public void generateScript(@NotNull ScriptWriter scriptWriter, @NotNull ScrewdrivingSetupData data, @NotNull ExtendedProgramAPIProvider apiProvider) {
        Program program = Objects.requireNonNull(data.selectedProgram());
        String refPoseExpression = scriptWriter.getResolvedVariableName(NodeFactory.get_spin_target(apiProvider.getProgramAPIProvider().getProgramAPI()));
        ScriptParser parser = new ScriptParser(scriptWriter);
        this.generateProgramScript(parser, program, refPoseExpression);
    }

    private void generateProgramScript(@NotNull ScriptParser parser, @NotNull Program program, @NotNull String refPoseExpression) {
        String errorPopupTitle = this.textResource.load(ScrewdrivingSetupText.ERROR_TITLE);
        parser.parseToScript(DriveScrewScriptGenerator.initializationScript(), refPoseExpression, Double.toString(program.reference_depth().getAs(Length.Unit.M)), Double.toString(program.start_depth().getAs(Length.Unit.M)), errorPopupTitle);
        if (program.is_force_controlled().booleanValue()) {
            parser.parseToScript(DriveScrewScriptGenerator.screwProcessScriptWithForceControl(), program.uuid().toString());
        } else {
            parser.parseToScript(DriveScrewScriptGenerator.screwProcessScriptWithSpeedControl(), program.uuid().toString());
        }
    }
}

