/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.tcp_payload;

import com.spin.core.installation_node.tcp_payload.Tool;
import com.ur.urcap.api.domain.InstallationAPI;
import com.ur.urcap.api.domain.payload.PayloadContributionModel;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.PositionFactory;
import com.ur.urcap.api.domain.value.dynamics.InertiaMatrix;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.urcap.api.domain.value.simple.MomentOfInertia;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import org.jetbrains.annotations.NotNull;

public class ToolSpecs {
    @NotNull
    private final InstallationAPI api;

    public ToolSpecs(@NotNull InstallationAPI api) {
        this.api = api;
    }

    @NotNull
    String id(@NotNull Tool tool) {
        switch (tool) {
            case SD35: {
                return "spin_sd35";
            }
            case SD70: {
                return "spin_sd70";
            }
        }
        throw new IllegalArgumentException("Unknown tool: " + (Object)((Object)tool));
    }

    @NotNull
    String tcpName(@NotNull Tool tool) {
        switch (tool) {
            case SD35: {
                return "Spin_SD35_T";
            }
            case SD70: {
                return "Spin_SD70_T";
            }
        }
        throw new IllegalArgumentException("Unknown tool: " + (Object)((Object)tool));
    }

    @NotNull
    String payloadName(@NotNull Tool tool) {
        switch (tool) {
            case SD35: {
                return "Spin_SD35_P";
            }
            case SD70: {
                return "Spin_SD70_P";
            }
        }
        throw new IllegalArgumentException("Unknown tool: " + (Object)((Object)tool));
    }

    @NotNull
    Pose tcpPose(@NotNull Tool tool) {
        PoseFactory poseFactory = this.api.getValueFactoryProvider().getPoseFactory();
        switch (tool) {
            case SD35: {
                return poseFactory.createPose(0.0, -248.6, 106.6, 90.0, 0.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
            }
            case SD70: {
                return poseFactory.createPose(0.0, -262.6, 106.6, 90.0, 0.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
            }
        }
        throw new IllegalArgumentException("Unknown tool: " + (Object)((Object)tool));
    }

    @NotNull
    Mass mass(@NotNull Tool tool) {
        SimpleValueFactory valueFactory = this.api.getValueFactoryProvider().getSimpleValueFactory();
        switch (tool) {
            case SD35: {
                return valueFactory.createMass(2.4, Mass.Unit.KG);
            }
            case SD70: {
                return valueFactory.createMass(2.5, Mass.Unit.KG);
            }
        }
        throw new IllegalArgumentException("Unknown tool: " + (Object)((Object)tool));
    }

    @NotNull
    Position cogPosition(@NotNull Tool tool) {
        PositionFactory positionFactory = this.api.getValueFactoryProvider().getPositionFactory();
        switch (tool) {
            case SD35: {
                return positionFactory.createPosition(0.0, -47.0, 79.0, Length.Unit.MM);
            }
            case SD70: {
                return positionFactory.createPosition(0.0, -57.0, 82.0, Length.Unit.MM);
            }
        }
        throw new IllegalArgumentException("Unknown tool: " + (Object)((Object)tool));
    }

    @NotNull
    InertiaMatrix inertiaMatrix(@NotNull Tool tool) {
        PayloadContributionModel payloadModel = this.api.getPayloadContributionModel();
        switch (tool) {
            case SD35: {
                return payloadModel.createInertiaMatrix(0.0302, 0.0182, 0.0129, 0.0, 0.0, -0.00985, MomentOfInertia.Unit.KG_M2);
            }
            case SD70: {
                return payloadModel.createInertiaMatrix(0.030201, 0.018201, 0.012901, 1.0, 1.0, -0.009851, MomentOfInertia.Unit.KG_M2);
            }
        }
        throw new IllegalArgumentException("Unknown tool: " + (Object)((Object)tool));
    }
}

