/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup.approach;

import com.spin.core.program_node.safe_approach.SafeApproachService;
import com.spin.core.program_node.screwdriving_setup.approach.ApproachData;
import com.spin.core.program_node.screwdriving_setup.approach.ApproachText;
import com.spin.domain.MultiInstall;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.i18n.TextResource;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.domain.program.ProgramModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.AssignmentNode;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.AssignmentNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.ExpressionAssignmentNodeConfig;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.expression.ExpressionBuilder;
import com.ur.urcap.api.domain.value.expression.InvalidExpressionException;
import org.jetbrains.annotations.NotNull;

public class ApproachContribution
implements ProgramNodeContribution {
    @NotNull
    private final String nodeTitle;
    @NotNull
    private final ProgramModel programModel;
    @NotNull
    private final ExpressionBuilder expressionBuilder;
    @NotNull
    private final ApproachData data;

    ApproachContribution(@NotNull ExtendedProgramAPIProvider apiProvider, @NotNull ApproachData data, @NotNull CreationContext.NodeCreationType nodeCreationType) throws TreeStructureException {
        TextResource textResource = apiProvider.getTextResource();
        this.nodeTitle = textResource.load(ApproachText.APPROACH);
        this.programModel = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel();
        this.expressionBuilder = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().createExpressionBuilder();
        this.data = data;
        if (nodeCreationType == CreationContext.NodeCreationType.NEW) {
            this.buildSubTree(apiProvider, this);
        }
    }

    private void buildSubTree(@NotNull ExtendedProgramAPIProvider apiProvider, @NotNull ApproachContribution contribution) throws TreeStructureException {
        TreeNode rootNode = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)contribution);
        ProgramNodeFactory factory = this.programModel.getProgramNodeFactory();
        rootNode.addChild((ProgramNode)this.createScrreProgramStartPoseNode());
        rootNode.addChild((ProgramNode)factory.createURCapProgramNode(SafeApproachService.class));
    }

    @NotNull
    private AssignmentNode createScrreProgramStartPoseNode() {
        AssignmentNode assignmentNode = this.programModel.getProgramNodeFactory().createAssignmentNode();
        ExpressionAssignmentNodeConfig config = assignmentNode.getConfigFactory().createExpressionConfig(this.data.screwProgramStartPoseVariable(), this.createExpression());
        assignmentNode.setConfig((AssignmentNodeConfig)config);
        return assignmentNode;
    }

    @NotNull
    private Expression createExpression() {
        try {
            this.expressionBuilder.append(MultiInstall.urscriptPrefix() + "program_start_pose()");
            return this.expressionBuilder.build();
        }
        catch (InvalidExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public void openView() {
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.nodeTitle;
    }

    public boolean isDefined() {
        return true;
    }

    public void generateScript(ScriptWriter writer) {
        SpinLog.print("Generating script for approach");
        writer.writeChildren();
    }
}

