/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup.on_Fault;

import com.spin.core.program_node.screwdriving_setup.on_Fault.OnFaultText;
import com.spin.domain.MultiInstall;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.api.NodeFactory;
import com.spin.util.i18n.TextResource;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.expression.ExpressionBuilder;
import com.ur.urcap.api.domain.value.expression.InvalidExpressionException;
import com.ur.urcap.api.domain.variable.Variable;
import org.jetbrains.annotations.NotNull;

public class OnFaultContribution
implements ProgramNodeContribution {
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final String nodeTitle;

    OnFaultContribution(@NotNull ExtendedProgramAPIProvider apiProvider, @NotNull CreationContext.NodeCreationType nodeCreationType) {
        this.textResource = apiProvider.getTextResource();
        this.nodeTitle = apiProvider.getTextResource().load(OnFaultText.ON_FAULT);
        if (nodeCreationType == CreationContext.NodeCreationType.NEW) {
            OnFaultContribution.buildSubTree(apiProvider, this, this.textResource);
        }
    }

    private static void buildSubTree(@NotNull ExtendedProgramAPIProvider apiProvider, @NotNull OnFaultContribution contribution, @NotNull TextResource textResource) {
        Expression spin_result_evaluation;
        TreeNode rootNode = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)contribution);
        ProgramNodeFactory programNodeFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getProgramNodeFactory();
        Variable spin_message = NodeFactory.get_spin_message(apiProvider.getProgramAPIProvider().getProgramAPI());
        ExpressionBuilder expressionBuilder = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().createExpressionBuilder();
        try {
            spin_result_evaluation = expressionBuilder.append(MultiInstall.urscriptPrefix() + "program_messages()").build();
        }
        catch (Exception e) {
            SpinLog.print("Cannot create expression: " + e.getMessage());
            throw new RuntimeException(e);
        }
        try {
            if (MultiInstall.isMultiInstall()) {
                NodeFactory.addAbortFlagAssignmentNode(apiProvider.getProgramAPIProvider().getProgramAPI(), rootNode, programNodeFactory);
            }
            NodeFactory.addAssignmentNode(rootNode, programNodeFactory, spin_message, spin_result_evaluation);
            NodeFactory.addCommentNode(rootNode, programNodeFactory, textResource.load(OnFaultText.HANDLE_ERROR_TEXT));
            NodeFactory.addHaltNode(rootNode, programNodeFactory);
        }
        catch (TreeStructureException | InvalidExpressionException e) {
            SpinLog.print("Cannot add child nodes to onFault node: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void openView() {
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.nodeTitle;
    }

    public boolean isDefined() {
        return true;
    }

    public void generateScript(ScriptWriter writer) {
        writer.appendLine("elif (" + MultiInstall.urscriptPrefix() + "result_evaluation == 0):");
        writer.appendLine("  sync()");
        writer.writeChildren();
        writer.appendLine("end");
    }
}

