/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.proxy.factory;

import com.spin.bridge_communication.URCapInterfaceProvider;
import com.spin.bridge_communication.proxy.connector.XmlRpcConnector;
import com.spin.bridge_communication.proxy.factory.DigitalOutputProvider;
import com.spin.bridge_communication.proxy.handler.HeartbeatHandlerImpl;
import com.spin.bridge_communication.proxy.handler.StateHandlerImpl;
import com.spin.bridge_communication.proxy.monitorer.XmlRpcMonitorer;
import com.spin.bridge_communication.proxy.state_machine.ConnectionEvent;
import com.spin.bridge_communication.proxy.state_machine.ConnectionStateMachine;
import com.spin.bridge_communication.proxy.xmlrpc_client.XmlRpcBridgeClient;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.NotNull;

public class ConnectionFactory {
    @NotNull
    public ConnectionStateMachine createStateMachine(@NotNull XmlRpcBridgeClient bridgeClient, @NotNull URCapInterfaceProvider interfaceProvider, @NotNull DigitalOutputProvider outputProvider) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        HeartbeatHandlerImpl heartbeatHandler = new HeartbeatHandlerImpl(executor);
        StateHandlerImpl stateHandler = new StateHandlerImpl(bridgeClient, interfaceProvider, outputProvider.getFreedriveButtonOutput(), outputProvider.getFrontButtonOutput());
        XmlRpcMonitorer monitorer = new XmlRpcMonitorer(executor, bridgeClient, heartbeatHandler, stateHandler);
        XmlRpcConnector connector = new XmlRpcConnector(executor, bridgeClient);
        ConnectionStateMachine stateMachine = new ConnectionStateMachine(connector, monitorer);
        connector.setOnSuccessCallback(() -> stateMachine.handleEvent(ConnectionEvent.CONNECTION_ESTABLISHED));
        monitorer.setXmlRpcExceptionCallback(() -> stateMachine.handleEvent(ConnectionEvent.COMMUNICATION_FAILED));
        heartbeatHandler.setOnKickedCallback(() -> stateMachine.handleEvent(ConnectionEvent.WATCHDOG_KICKED));
        heartbeatHandler.setOnDiedCallback(() -> stateMachine.handleEvent(ConnectionEvent.WATCHDOG_DIED));
        return stateMachine;
    }
}

