/*
 * Decompiled with CFR 0.152.
 */
package com.spin.domain;

import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class ScrewFeeder {
    @NotNull
    private final UUID id;
    @NotNull
    private final String name;
    @NotNull
    private final Pose pickUpPose;
    @NotNull
    private final JointPositions pickUpJointPositions;
    @NotNull
    private final Length screwLength;

    public ScrewFeeder(@NotNull UUID id, @NotNull String name, @NotNull Pose pickUpPose, @NotNull JointPositions pickUpJointPositions, @NotNull Length screwLength) {
        this.id = id;
        this.name = name;
        this.pickUpPose = pickUpPose;
        this.pickUpJointPositions = pickUpJointPositions;
        this.screwLength = screwLength;
        assert (screwLength.getAs(Length.Unit.MM) >= 0.0);
    }

    @NotNull
    public UUID id() {
        return this.id;
    }

    @NotNull
    public String name() {
        return this.name;
    }

    @NotNull
    public Pose pickUpPose() {
        return this.pickUpPose;
    }

    @NotNull
    public JointPositions pickUpJointPositions() {
        return this.pickUpJointPositions;
    }

    @NotNull
    public Length screwLength() {
        return this.screwLength;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ScrewFeeder)) {
            return false;
        }
        return ((ScrewFeeder)o).id.equals(this.id);
    }
}

