/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.bit_changing_station;

import com.spin.core.installation_node.bit_changing_station.BitChangingStationContribution;
import com.spin.core.installation_node.bit_changing_station.BitChangingStationText;
import com.spin.domain.BitChangingStation;
import com.spin.ui.callback.OnOkCallback;
import com.spin.ui.callback.OnOkPositionCallback;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.Label;
import com.spin.ui.component.inputfield.InputField;
import com.spin.ui.image.SpinImage;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback2;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.Position;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditStationView {
    @NotNull
    private final Label nameLabel;
    @NotNull
    private final InputField<String> nameValue;
    @NotNull
    private final JButton teachAButton;
    @NotNull
    private final JButton teachBButton;
    @NotNull
    private final JButton teachCButton;
    @NotNull
    private final JButton verifyPositionButton;
    @NotNull
    private final JButton okButton;
    @NotNull
    private final JButton cancelButton;
    @NotNull
    private final ImageIcon pointAIcon;
    @NotNull
    private final ImageIcon pointBIcon;
    @NotNull
    private final ImageIcon pointCIcon;
    @NotNull
    private final ImagePanel imagePanel;
    @NotNull
    private final Label invalidPositionsLabel;
    @NotNull
    private UUID stationID = UUID.randomUUID();
    @Nullable
    private Pose referencePose = null;
    @Nullable
    private Position positionA = null;
    @Nullable
    private Position positionB = null;
    @Nullable
    private Position positionC = null;

    EditStationView(@NotNull ExtendedViewAPIProvider apiProvider) {
        TextResource textResource = apiProvider.getTextResource();
        ImageIcon moveTeachIcon = UR_Icon.MOVE_TEACH.load();
        ImageIcon wizardIcon = UR_Icon.WIZARD.load();
        ImageIcon warningIcon = UR_Icon.WARNING_SMALL.load();
        ImageIcon approveIcon = UR_Icon.APPROVE.load();
        ImageIcon cancelIcon = UR_Icon.CANCEL.load();
        this.nameLabel = new Label(textResource.load(BitChangingStationText.NAME));
        this.nameValue = new InputField(InputField.Alignment.TEXT);
        this.teachAButton = new ButtonMedium(textResource.load(BitChangingStationText.TEACH_A), moveTeachIcon);
        this.teachBButton = new ButtonMedium(textResource.load(BitChangingStationText.TEACH_B), moveTeachIcon);
        this.teachCButton = new ButtonMedium(textResource.load(BitChangingStationText.TEACH_C), moveTeachIcon);
        this.verifyPositionButton = new ButtonMedium(textResource.load(BitChangingStationText.VERIFY_POSITION), wizardIcon);
        this.okButton = new ButtonMedium(textResource.load(BitChangingStationText.OK), approveIcon);
        this.cancelButton = new ButtonMedium(textResource.load(BitChangingStationText.CANCEL), cancelIcon);
        this.invalidPositionsLabel = new Label(textResource.load(BitChangingStationText.INVALID_POSIITONS));
        this.invalidPositionsLabel.setIcon(warningIcon);
        Dimension imageSize = new Dimension(500, -1);
        this.pointAIcon = SpinImage.BIT_CHANGING_STATION_POINT_A.load(imageSize);
        this.pointBIcon = SpinImage.BIT_CHANGING_STATION_POINT_B.load(imageSize);
        this.pointCIcon = SpinImage.BIT_CHANGING_STATION_POINT_C.load(imageSize);
        this.imagePanel = new ImagePanel(this.pointAIcon);
    }

    @NotNull
    JPanel createLeftPanel() {
        JPanel panel = new JPanel((LayoutManager)UR_MigLayout.equalColumns(6, 20, "30[]10[]50[]10[]10[]10[]10[30,top]10[]push"));
        panel.add((Component)this.nameLabel, "cell 1 0, span 4, left");
        panel.add((Component)this.nameValue.getTextField(), "cell 1 1, span 4, grow");
        panel.add((Component)this.teachAButton, "cell 1 2, span 4, grow");
        panel.add((Component)this.teachBButton, "cell 1 3, span 4, grow");
        panel.add((Component)this.teachCButton, "cell 1 4, span 4, grow");
        panel.add((Component)this.verifyPositionButton, "cell 1 5, span 4, grow");
        panel.add((Component)this.invalidPositionsLabel, "cell 1 6, span 4");
        panel.add((Component)this.okButton, "cell 1 7, span 2, grow");
        panel.add((Component)this.cancelButton, "cell 3 7, span 2, grow");
        return panel;
    }

    @NotNull
    JPanel createRightPanel() {
        JPanel panel = new JPanel((LayoutManager)UR_MigLayout.singleColumn(20, "[grow]"));
        panel.add((Component)this.imagePanel, "right");
        return panel;
    }

    void registerListeners(@NotNull BitChangingStationContribution contribution) {
        this.nameValue.getTextField().addSimpleClickListener(() -> this.showNameKeyboard(contribution));
        this.teachAButton.addActionListener(event -> this.teachPositionA(contribution));
        this.teachBButton.addActionListener(event -> this.teachPositionB(contribution));
        this.teachCButton.addActionListener(event -> this.teachPositionC(contribution));
        this.verifyPositionButton.addActionListener(event -> this.showVerifyPositionWizard(contribution));
        this.okButton.addActionListener(event -> {
            this.addNewStationFromEnteredValues(contribution);
            contribution.onExitEditStation();
        });
        this.cancelButton.addActionListener(event -> contribution.onExitEditStation());
    }

    void clearStation() {
        this.stationID = UUID.randomUUID();
        this.nameValue.setValue(null);
        this.nameValue.getTextField().setInputValid(false);
        this.referencePose = null;
        this.positionA = null;
        this.positionB = null;
        this.positionC = null;
        this.teachBButton.setEnabled(false);
        this.teachCButton.setEnabled(false);
        this.verifyPositionButton.setEnabled(false);
        this.invalidPositionsLabel.setVisible(false);
        this.okButton.setEnabled(false);
        this.imagePanel.setIcon(this.pointAIcon);
    }

    void setStation(@NotNull BitChangingStation station) {
        this.stationID = station.id();
        this.nameValue.setValue(station.name());
        this.nameValue.getTextField().setInputValid(true);
        this.referencePose = station.referencePose();
        this.positionA = null;
        this.positionB = null;
        this.positionC = null;
        this.teachBButton.setEnabled(false);
        this.teachCButton.setEnabled(false);
        this.verifyPositionButton.setEnabled(true);
        this.invalidPositionsLabel.setVisible(false);
        this.okButton.setEnabled(true);
        this.imagePanel.setIcon(this.pointAIcon);
    }

    private void addNewStationFromEnteredValues(@NotNull BitChangingStationContribution contribution) {
        String name = this.nameValue.getValue();
        assert (name != null);
        assert (this.referencePose != null);
        System.out.println("Name before creation: " + name);
        BitChangingStation station = new BitChangingStation(this.stationID, name, this.referencePose, contribution.getAPIProvider());
        System.out.println("Created station");
        System.out.println("  Name: " + station.name());
        System.out.println("  ID:   " + station.id());
        System.out.println("  Pose: " + station.referencePose());
        contribution.storeStation(station);
    }

    private void enableOKButtonIfAllIsConfigured() {
        boolean nameIsConfigured = this.nameValue.getValue() != null;
        boolean poseIsConfigured = this.referencePose != null;
        this.okButton.setEnabled(nameIsConfigured && poseIsConfigured);
    }

    private void showNameKeyboard(@NotNull BitChangingStationContribution contribution) {
        KeyboardTextInput keyboard = contribution.getStationNameKeyboard(this.nameValue.getValue());
        keyboard.show((JTextField)this.nameValue.getTextField(), new OnOkCallback<String>(name -> {
            this.nameValue.setValue((String)name);
            this.nameValue.getTextField().setInputValid(true);
            this.enableOKButtonIfAllIsConfigured();
        }));
    }

    private void teachPositionA(@NotNull BitChangingStationContribution contribution) {
        contribution.getUserInteraction().getUserDefinedRobotPosition((RobotPositionCallback2)new OnOkPositionCallback(parameters -> {
            this.positionA = parameters.getPose().getPosition();
            this.invalidPositionsLabel.setVisible(false);
            this.teachBButton.setEnabled(true);
            this.imagePanel.setIcon(this.pointBIcon);
        }));
    }

    private void teachPositionB(@NotNull BitChangingStationContribution contribution) {
        contribution.getUserInteraction().getUserDefinedRobotPosition((RobotPositionCallback2)new OnOkPositionCallback(parameters -> {
            this.positionB = parameters.getPose().getPosition();
            this.teachCButton.setEnabled(true);
            this.imagePanel.setIcon(this.pointCIcon);
        }));
    }

    private void teachPositionC(@NotNull BitChangingStationContribution contribution) {
        contribution.getUserInteraction().getUserDefinedRobotPosition((RobotPositionCallback2)new OnOkPositionCallback(parameters -> {
            this.positionC = parameters.getPose().getPosition();
            this.onAllPosesSet(contribution);
            this.enableOKButtonIfAllIsConfigured();
        }));
    }

    private void onAllPosesSet(@NotNull BitChangingStationContribution contribution) {
        try {
            this.calculateReferenceAndEnableButtons(contribution);
        }
        catch (BitChangingStation.InvalidTeachPoints e) {
            this.resetTeachState();
        }
    }

    private void calculateReferenceAndEnableButtons(@NotNull BitChangingStationContribution contribution) throws BitChangingStation.InvalidTeachPoints {
        assert (this.positionA != null);
        assert (this.positionB != null);
        assert (this.positionC != null);
        this.referencePose = BitChangingStation.calculateReferencePose(this.positionA, this.positionB, this.positionC, contribution.getValueFactoryProvider());
        this.verifyPositionButton.setEnabled(true);
    }

    private void resetTeachState() {
        this.positionA = null;
        this.positionB = null;
        this.positionC = null;
        this.teachBButton.setEnabled(false);
        this.teachCButton.setEnabled(false);
        this.verifyPositionButton.setEnabled(false);
        this.imagePanel.setIcon(this.pointAIcon);
        this.invalidPositionsLabel.setVisible(true);
    }

    private void showVerifyPositionWizard(@NotNull BitChangingStationContribution contribution) {
        assert (this.referencePose != null);
        BitChangingStation station = new BitChangingStation(this.stationID, "", this.referencePose, contribution.getAPIProvider());
        contribution.onVerifyPositionFromEditView(station.poseAbovePointB(), station.poseOfPointB());
    }
}

