/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.script_function;

import com.spin.core.installation_node.script_function.ScriptFunction;
import com.spin.util.script.ScriptParser;
import com.ur.urcap.api.domain.function.FunctionException;
import com.ur.urcap.api.domain.function.FunctionModel;
import java.io.InputStream;
import java.net.InetAddress;
import org.jetbrains.annotations.NotNull;

public class ScriptFunctionRegistration {
    public static void addAllFunctions(@NotNull FunctionModel model) throws FunctionException {
        for (ScriptFunction function : ScriptFunction.values()) {
            model.addFunction(function.functionName(), function.argumentNames());
        }
    }

    public static void generateToolFunctionScript(@NotNull ScriptParser parser, @NotNull InetAddress bridgeIP) {
        parser.parseToScript(ScriptFunction.scriptStream(), bridgeIP.getHostAddress());
    }

    public static void generateUtilFunctionScript(@NotNull ScriptParser parser) {
        InputStream scriptStream = ScriptFunction.class.getResourceAsStream("util_functions/pose_equal.script");
        assert (scriptStream != null) : "Script resource file not found";
        parser.parseToScript(scriptStream, new String[0]);
    }

    public static void generateMoveFunctionScript(@NotNull ScriptParser parser) {
        InputStream scriptStream = ScriptFunction.class.getResourceAsStream("move_functions/safe_move.script");
        assert (scriptStream != null) : "Script resource file not found";
        parser.parseToScript(scriptStream, new String[0]);
        scriptStream = ScriptFunction.class.getResourceAsStream("move_functions/force_move_to_pose.script");
        assert (scriptStream != null) : "Script resource file not found";
        parser.parseToScript(scriptStream, new String[0]);
    }
}

