/*
 * Decompiled with CFR 0.152.
 */
package com.spin.util.math;

import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.ValueFactoryProvider;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.jetbrains.annotations.NotNull;

public class PoseMath {
    @NotNull
    private final ValueFactoryProvider factoryProvider;

    public PoseMath(@NotNull ValueFactoryProvider factoryProvider) {
        this.factoryProvider = factoryProvider;
    }

    public static double distanceBetween(@NotNull Position a, @NotNull Position b, @NotNull Length.Unit unit) {
        double xDiff = a.getX(unit) - b.getX(unit);
        double yDiff = a.getY(unit) - b.getY(unit);
        double zDiff = a.getZ(unit) - b.getZ(unit);
        return new Vector3D(xDiff, yDiff, zDiff).getNorm();
    }

    @NotNull
    public static Vector3D asApachePosition(@NotNull Position urPosition) {
        return new Vector3D(urPosition.getX(Length.Unit.M), urPosition.getY(Length.Unit.M), urPosition.getZ(Length.Unit.M));
    }

    @NotNull
    public static Rotation asApacheRotation(@NotNull com.ur.urcap.api.domain.value.Rotation urRotation) {
        Vector3D eaaAxis = new Vector3D(urRotation.getRX(Angle.Unit.RAD), urRotation.getRY(Angle.Unit.RAD), urRotation.getRZ(Angle.Unit.RAD));
        return eaaAxis.getNorm() == 0.0 ? Rotation.IDENTITY : new Rotation(eaaAxis.normalize(), eaaAxis.getNorm(), RotationConvention.VECTOR_OPERATOR);
    }

    @NotNull
    public Position asURPosition(@NotNull Vector3D apachePosition) {
        return this.factoryProvider.getPositionFactory().createPosition(apachePosition.getX(), apachePosition.getY(), apachePosition.getZ(), Length.Unit.M);
    }

    @NotNull
    public com.ur.urcap.api.domain.value.Rotation asURRotation(@NotNull Rotation apacheRotation) {
        Vector3D eaaAxis = apacheRotation.getAngle() == 0.0 ? new Vector3D(0.0, 0.0, 0.0) : apacheRotation.getAxis(RotationConvention.VECTOR_OPERATOR).scalarMultiply(apacheRotation.getAngle());
        return this.factoryProvider.getRotationFactory().createRotation(eaaAxis.getX(), eaaAxis.getY(), eaaAxis.getZ(), Angle.Unit.RAD);
    }

    @NotNull
    public Pose asURPose(@NotNull Vector3D apachePosition, @NotNull Rotation apacheRotation) {
        return this.factoryProvider.getPoseFactory().createPose(this.asURPosition(apachePosition), this.asURRotation(apacheRotation));
    }

    @NotNull
    public Transformation makeTransformationToBaseFrame(@NotNull Pose fromFrame) {
        return new Transformation(this, fromFrame);
    }

    public static class Transformation {
        @NotNull
        private final PoseMath poseMath;
        @NotNull
        private final Vector3D framePosition;
        @NotNull
        private final Rotation frameRotation;

        Transformation(@NotNull PoseMath poseMath, @NotNull Pose fromFrame) {
            this.poseMath = poseMath;
            this.framePosition = PoseMath.asApachePosition(fromFrame.getPosition());
            this.frameRotation = PoseMath.asApacheRotation(fromFrame.getRotation());
        }

        public Pose applyTo(@NotNull Pose pose) {
            Vector3D posePos = PoseMath.asApachePosition(pose.getPosition());
            Rotation poseRot = PoseMath.asApacheRotation(pose.getRotation());
            Vector3D transformedPosition = this.frameRotation.applyTo(posePos).add((Vector)this.framePosition);
            Rotation transformedRotation = this.frameRotation.applyTo(poseRot);
            return this.poseMath.asURPose(transformedPosition, transformedRotation);
        }
    }
}

