/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup;

import com.spin.bridge_communication.program_data.ProgramDataConsumer;
import com.spin.bridge_communication.program_data.ProgramDataProvider;
import com.spin.core.installation_node.InstallationContribution;
import com.spin.domain.Part;
import com.spin.domain.Program;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableException;
import com.ur.urcap.api.domain.variable.VariableModel;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrewdrivingSetupData {
    @NotNull
    private final DataModel model;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final SimpleValueFactory simpleValueFactory;
    @NotNull
    private final ProgramDataProvider programDataProvider;
    @NotNull
    private final VariableModel variableModel;
    @NotNull
    private Runnable availablePartsChangedCallback = () -> {};
    @NotNull
    private final ProgramDataConsumer programDataConsumer = parts -> this.availablePartsChangedCallback.run();

    ScrewdrivingSetupData(@NotNull DataModel model, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.model = model;
        ProgramAPI programAPI = apiProvider.getProgramAPIProvider().getProgramAPI();
        this.undoRedoManager = programAPI.getUndoRedoManager();
        this.simpleValueFactory = programAPI.getValueFactoryProvider().getSimpleValueFactory();
        this.variableModel = programAPI.getVariableModel();
        this.programDataProvider = ((InstallationContribution)programAPI.getInstallationNode(InstallationContribution.class)).getProgramDataProvider();
    }

    void setOnPartsChangedCallback(@NotNull Runnable callback) {
        this.availablePartsChangedCallback = callback;
        this.programDataProvider.registerConsumer(this.programDataConsumer);
    }

    void clearOnPartsChangedCallback() {
        this.availablePartsChangedCallback = () -> {};
        this.programDataProvider.unregisterConsumer(this.programDataConsumer);
    }

    @NotNull
    Set<Part> availableParts() {
        return this.programDataProvider.getData();
    }

    @NotNull
    List<Program> availablePrograms() {
        Part selectedPart = this.selectedPart();
        return selectedPart == null ? Collections.emptyList() : selectedPart.programs();
    }

    @Nullable
    Part selectedPart() {
        Integer selectedID = this.loadSelectedPartID();
        return selectedID == null ? null : (Part)this.availableParts().stream().filter(part -> part.id() == selectedID.intValue()).findFirst().orElse(null);
    }

    void setSelectedPart(@NotNull Part part) {
        this.undoRedoManager.recordChanges(() -> this.model.set("part", part.id()));
    }

    @Nullable
    private Integer loadSelectedPartID() {
        int id = this.model.get("part", -1);
        return id == -1 ? null : Integer.valueOf(id);
    }

    @Nullable
    Program selectedProgram() {
        Integer selectedID = this.loadSelectedProgramID();
        return selectedID == null ? null : (Program)this.availablePrograms().stream().filter(program -> program.id() == selectedID.intValue()).findFirst().orElse(null);
    }

    void setSelectedProgram(@NotNull Program program) {
        this.undoRedoManager.recordChanges(() -> this.model.set("program", program.id()));
    }

    void clearSelectedProgram() {
        this.undoRedoManager.recordChanges(() -> this.model.remove("program"));
    }

    @Nullable
    private Integer loadSelectedProgramID() {
        int id = this.model.get("program", -1);
        return id == -1 ? null : Integer.valueOf(id);
    }

    @Nullable
    Pose screwPose() {
        return this.model.get("pose", (Pose)null);
    }

    void setScrewPose(@NotNull Pose pose) {
        this.undoRedoManager.recordChanges(() -> this.model.set("pose", pose));
    }

    boolean approachIsEnabled() {
        return this.model.get("approachIsEnabled", true);
    }

    void setApproachEnabled(boolean enabled) {
        this.undoRedoManager.recordChanges(() -> this.model.set("approachIsEnabled", enabled));
    }

    boolean useSpinTarget() {
        return this.model.get("useSpinTarget", false);
    }

    void setUseSpinTarget(boolean selected) {
        this.model.set("useSpinTarget", selected);
    }

    @NotNull
    Force robotForce() {
        return this.model.get("robotForce", this.simpleValueFactory.createForce(20.0, Force.Unit.N));
    }

    void setRobotForce(@NotNull Force force) {
        this.undoRedoManager.recordChanges(() -> this.model.set("robotForce", force));
    }

    @NotNull
    Length s1Distance() {
        return this.model.get("s1Distance", this.simpleValueFactory.createLength(6.0, Length.Unit.MM));
    }

    void setS1Distance(@NotNull Length distance) {
        this.undoRedoManager.recordChanges(() -> this.model.set("s1Distance", distance));
    }

    boolean isValid() {
        return this.selectedPart() != null && this.selectedProgram() != null && (this.screwPose() != null || this.useSpinTarget());
    }

    @NotNull
    Length minAllowedS1Distance() {
        return this.simpleValueFactory.createLength(0.0, Length.Unit.MM);
    }

    @NotNull
    Length maxAllowedS1Distance() {
        return this.simpleValueFactory.createLength(40.0, Length.Unit.MM);
    }

    @NotNull
    Variable spinTargetVariable() {
        return this.findExistingSpinTargetVariable().orElseGet(this::createSpinTargetVariable);
    }

    @NotNull
    private Optional<Variable> findExistingSpinTargetVariable() {
        return this.variableModel.get(variable -> variable.getDisplayName().equals("spin_target")).stream().findFirst();
    }

    @NotNull
    private Variable createSpinTargetVariable() {
        try {
            return this.variableModel.getVariableFactory().createGlobalVariable("spin_target");
        }
        catch (VariableException e) {
            SpinLog.print("Unable to create spin_target variable");
            throw new RuntimeException(e);
        }
    }
}

