/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.proxy.state_machine;

import com.github.oxo42.stateless4j.StateMachine;
import com.github.oxo42.stateless4j.StateMachineConfig;
import com.spin.bridge_communication.proxy.state_machine.ConnectionEvent;
import com.spin.bridge_communication.proxy.state_machine.Connector;
import com.spin.bridge_communication.proxy.state_machine.Monitorer;
import org.jetbrains.annotations.NotNull;

public class ConnectionStateMachine {
    @NotNull
    private final StateMachine<State, ConnectionEvent> stateMachine;

    public ConnectionStateMachine(@NotNull Connector connector, @NotNull Monitorer monitorer) {
        this.stateMachine = ConnectionStateMachine.createStateMachine(connector, monitorer);
    }

    @NotNull
    private static StateMachine<State, ConnectionEvent> createStateMachine(@NotNull Connector connector, @NotNull Monitorer monitorer) {
        StateMachineConfig config = new StateMachineConfig();
        KickCounter kickCounter = new KickCounter();
        State initialState = State.IDLE;
        config.configure((Object)State.IDLE).permit((Object)ConnectionEvent.CONNECT, (Object)State.TRYING_TO_CONNECT);
        config.configure((Object)State.TRYING_TO_CONNECT).onEntry(connector::startConnecting).onExit(connector::stopConnecting).permitReentry((Object)ConnectionEvent.CONNECT).permit((Object)ConnectionEvent.CONNECTION_ESTABLISHED, (Object)State.CONSOLIDATING_CONNECTION, monitorer::monitorHeartbeat).ignore((Object)ConnectionEvent.COMMUNICATION_FAILED).ignore((Object)ConnectionEvent.WATCHDOG_KICKED).ignore((Object)ConnectionEvent.WATCHDOG_DIED);
        config.configure((Object)State.CONSOLIDATING_CONNECTION).onEntry(kickCounter::reset).permit((Object)ConnectionEvent.CONNECT, (Object)State.TRYING_TO_CONNECT, monitorer::stopMonitoring).permit((Object)ConnectionEvent.WATCHDOG_DIED, (Object)State.TRYING_TO_CONNECT, monitorer::stopMonitoring).permit((Object)ConnectionEvent.COMMUNICATION_FAILED, (Object)State.TRYING_TO_CONNECT, monitorer::stopMonitoring).permitInternalIf((Object)ConnectionEvent.WATCHDOG_KICKED, kickCounter::isNotDoneCounting, kickCounter::increment).permitIf((Object)ConnectionEvent.WATCHDOG_KICKED, (Object)State.CONNECTED, kickCounter::isDoneCounting);
        config.configure((Object)State.CONNECTED).onEntry(monitorer::monitorEverything).onExit(monitorer::stopMonitoring).permit((Object)ConnectionEvent.CONNECT, (Object)State.TRYING_TO_CONNECT).permit((Object)ConnectionEvent.WATCHDOG_DIED, (Object)State.TRYING_TO_CONNECT).permit((Object)ConnectionEvent.COMMUNICATION_FAILED, (Object)State.TRYING_TO_CONNECT).ignore((Object)ConnectionEvent.WATCHDOG_KICKED);
        return new StateMachine((Object)initialState, config);
    }

    @NotNull
    State state() {
        return (State)((Object)this.stateMachine.getState());
    }

    public void handleEvent(@NotNull ConnectionEvent event) {
        this.stateMachine.fire((Object)event);
    }

    private static class KickCounter {
        private int counter = 0;

        private KickCounter() {
        }

        void increment() {
            ++this.counter;
        }

        void reset() {
            this.counter = 0;
        }

        boolean isDoneCounting() {
            return this.counter >= 3;
        }

        boolean isNotDoneCounting() {
            return !this.isDoneCounting();
        }
    }

    static enum State {
        IDLE,
        TRYING_TO_CONNECT,
        CONSOLIDATING_CONNECTION,
        CONNECTED;

    }
}

