/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.hidden_nodes.move_direction;

import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionContribution;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionText;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.Label;
import com.spin.ui.component.inputfield.InputField;
import com.spin.ui.component.inputfield.UnitRenderer;
import com.spin.ui.component.keypad.UnitKeypad;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.ui.unit.UnitConverter;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.value.simple.Length;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MoveDirectionView
implements SwingProgramNodeView<MoveDirectionContribution> {
    @NotNull
    private final UnitType unitType;
    @NotNull
    private final Label moveDistanceUnit;
    @NotNull
    private final InputField<Length> moveDistanceField;
    @NotNull
    private final JPanel absolutPositionPanel;
    @NotNull
    private final ImagePanel logo;

    public MoveDirectionView(@NotNull ExtendedViewAPIProvider apiProvider) {
        this.unitType = apiProvider.getViewAPIProvider().getSystemAPI().getSystemSettings().getLocalization().getUnitType();
        TextResource textResource = apiProvider.getTextResource();
        this.moveDistanceUnit = new Label();
        this.absolutPositionPanel = new JPanel((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[]"));
        this.moveDistanceField = new InputField(InputField.Alignment.NUMBER);
        this.absolutPositionPanel.add((Component)new Label(textResource.load(MoveDirectionText.MOVE_DISTANCE)), "cell 0 0");
        this.absolutPositionPanel.add((Component)this.moveDistanceField.getTextField(), "cell 1 0,span 2, grow");
        this.absolutPositionPanel.add((Component)this.moveDistanceUnit, "cell 3 0");
        this.logo = new ImagePanel(SpinIcon.LOGO_PROGRAM_NODE.load());
    }

    void setUnitConverter(@NotNull UnitConverter unitConverter) {
        UnitRenderer renderer = new UnitRenderer(unitConverter, new DecimalFormat("#.##"));
        String unit = unitConverter.labelOf(Length.class);
        this.moveDistanceField.setRenderer(renderer);
        this.moveDistanceUnit.setText(unit);
    }

    public void buildUI(JPanel panel, ContributionProvider<MoveDirectionContribution> provider) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "push[]push[]"));
        panel.add((Component)this.absolutPositionPanel, "cell 0 0, span 12");
        panel.add((Component)this.logo, "cell 0 1, span 4, left");
        this.registerListeners(provider);
    }

    private void registerListeners(@NotNull ContributionProvider<MoveDirectionContribution> provider) {
        this.moveDistanceField.getTextField().addSimpleClickListener(() -> this.showScrewLengthKeypad((MoveDirectionContribution)provider.get()));
    }

    private void showScrewLengthKeypad(@NotNull MoveDirectionContribution contribution) {
        Length initialValue = this.moveDistanceField.getValue();
        UnitKeypad<Number, Length> keypad = this.unitType == UnitType.METRIC ? contribution.getMoveDistanceIntegerKeypad(initialValue) : contribution.getMoveDistanceDoubleKeypad(initialValue);
        keypad.show(this.moveDistanceField.getTextField(), length -> this.setMoveDistance((Length)length, contribution));
    }

    private void setMoveDistance(@NotNull Length moveDistance, @NotNull MoveDirectionContribution contribution) {
        this.moveDistanceField.setValue(moveDistance);
        contribution.setMoveDistance(moveDistance);
    }

    public void setMoveDistanceField(Length moveDistance) {
        this.moveDistanceField.setValue(moveDistance);
    }
}

