/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.proxy.handler;

import com.spin.bridge_communication.proxy.handler.NullFuture;
import com.spin.bridge_communication.proxy.monitorer.HeartbeatHandler;
import com.spin.domain.MonitoredItems;
import com.spin.util.SpinLog;
import com.spin.util.ToggleAction;
import com.ur.urcap.api.domain.io.DigitalIO;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class HeartbeatHandlerImpl
implements HeartbeatHandler {
    private static final long watchdogWindowDuration_ms = 2000L;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final DigitalIO digitalOutput;
    @NotNull
    private final ToggleAction heartbeatAction;
    @NotNull
    private Runnable onWatchdogKickedCallback = () -> SpinLog.print("No watchdog kicked callback has been set");
    @NotNull
    private Runnable onWatchdogDiedCallback = () -> SpinLog.print("No watchdog died callback has been set");
    @NotNull
    private Future<?> future = new NullFuture();

    public HeartbeatHandlerImpl(@NotNull ScheduledExecutorService executor, @NotNull DigitalIO digitalOutput) {
        this.executor = executor;
        this.digitalOutput = digitalOutput;
        this.heartbeatAction = new ToggleAction.Builder().doWhenToggledToTrue(this::restartWatchdogTimer).doWhenToggledToFalse(this::restartWatchdogTimer).buildWithInitialState(false);
    }

    public void setOnKickedCallback(@NotNull Runnable callback) {
        this.onWatchdogKickedCallback = callback;
    }

    public void setOnDiedCallback(@NotNull Runnable callback) {
        this.onWatchdogDiedCallback = callback;
    }

    @Override
    public void handleHeartbeat(@NotNull MonitoredItems monitoredItems) {
        boolean state = monitoredItems.heartbeatState();
        this.digitalOutput.setValue(state);
        this.heartbeatAction.setStateAndReact(state);
    }

    private void restartWatchdogTimer() {
        this.future.cancel(false);
        this.future = this.executor.schedule(this.onWatchdogDiedCallback, 2000L, TimeUnit.MILLISECONDS);
        this.onWatchdogKickedCallback.run();
    }
}

