/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.component;

import com.spin.ui.urstyle.UR_Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class ToggleSmall
extends JButton {
    boolean selected = false;

    public ToggleSmall(String text, Icon icon) {
        super(text, icon);
        this.setHeight(40);
        super.setOpaque(true);
        Border border = BorderFactory.createLineBorder(UR_Color.UR_BLUE, 2);
        Border marginBorder = BorderFactory.createEmptyBorder(0, 7, 0, 7);
        this.setBorder(BorderFactory.createCompoundBorder(border, marginBorder));
        this.setSelected(false);
    }

    public ToggleSmall(String text) {
        this(text, null);
    }

    public ToggleSmall(Icon icon) {
        this(null, icon);
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.setBackground(UR_Color.LIGHT_BLUE);
        } else {
            this.setBackground(UR_Color.WHITE);
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    protected void setHeight(int height) {
        Dimension preferredSize = super.getPreferredSize();
        Dimension maximumSize = super.getMaximumSize();
        preferredSize.height = height;
        maximumSize.height = Integer.MAX_VALUE;
        maximumSize.width = Integer.MAX_VALUE;
        super.setPreferredSize(preferredSize);
        super.setMaximumSize(maximumSize);
    }
}

