/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node;

import com.spin.api.ExtendedViewAPIProvider;
import com.spin.core.installation_node.InstallationContribution;
import com.spin.core.installation_node.InstallationText;
import com.spin.core.installation_node.bit_changing_station.BitChangingStationView;
import com.spin.core.installation_node.bridge_tool.BridgeAndToolView;
import com.spin.core.installation_node.screw_feeder.ScrewFeederView;
import com.spin.i18n.TextResource;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

public class InstallationView
implements SwingInstallationNodeView<InstallationContribution> {
    @NotNull
    private final JTabbedPane tabs = new JTabbedPane();
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final BridgeAndToolView bridgeAndToolView;
    @NotNull
    private final ScrewFeederView screwFeederView;
    @NotNull
    private final BitChangingStationView bitChangingStationView;
    @NotNull
    private final Map<Component, InstallationNodeContribution> panelMapping = new HashMap<Component, InstallationNodeContribution>(3);

    InstallationView(@NotNull ExtendedViewAPIProvider apiProvider) {
        this.textResource = apiProvider.getTextResource();
        this.bridgeAndToolView = new BridgeAndToolView(apiProvider);
        this.screwFeederView = new ScrewFeederView(apiProvider);
        this.bitChangingStationView = new BitChangingStationView(apiProvider);
    }

    public void buildUI(@NotNull JPanel panel, @NotNull InstallationContribution contribution) {
        panel.setLayout((LayoutManager)new MigLayout("insets 0, fill"));
        panel.add((Component)this.tabs, "grow");
        String bridgeAndToolTitle = this.textResource.load(InstallationText.BRIDGE_AND_TOOL);
        String screwFeederTitle = this.textResource.load(InstallationText.SCREW_FEEDER);
        String bitChangingStationTitle = this.textResource.load(InstallationText.BIT_CHANGING_STATION);
        this.addTab(bridgeAndToolTitle, this.bridgeAndToolView, contribution.getBridgeAndToolContribution());
        this.addTab(screwFeederTitle, this.screwFeederView, contribution.getScrewFeederContribution());
        this.addTab(bitChangingStationTitle, this.bitChangingStationView, contribution.getBitChangingStationContribution());
        this.registerListeners(contribution);
        contribution.setActiveContribution(this.getActiveContribution());
    }

    private InstallationNodeContribution getActiveContribution() {
        return this.panelMapping.get(this.tabs.getSelectedComponent());
    }

    private <Contribution extends InstallationNodeContribution> void addTab(@NotNull String title, @NotNull SwingInstallationNodeView<Contribution> view, @NotNull Contribution contribution) {
        JPanel panel = new JPanel();
        JPanel wrapperPanel = new JPanel((LayoutManager)new MigLayout("insets 5 0 0 0, fill"));
        wrapperPanel.add((Component)panel, "grow");
        view.buildUI(panel, contribution);
        this.tabs.addTab(title, wrapperPanel);
        this.panelMapping.put(wrapperPanel, contribution);
    }

    private void registerListeners(@NotNull InstallationContribution contribution) {
        this.tabs.addChangeListener(event -> contribution.onActiveContributionChange(this.getActiveContribution()));
    }

    @NotNull
    BridgeAndToolView getBridgeAndToolView() {
        return this.bridgeAndToolView;
    }

    @NotNull
    ScrewFeederView getScrewFeederView() {
        return this.screwFeederView;
    }

    @NotNull
    BitChangingStationView getBitChangingStationView() {
        return this.bitChangingStationView;
    }
}

