/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup.on_fault;

import com.spin.api.ExtendedProgramAPIProvider;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionInterface;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionService;
import com.spin.core.program_node.screwdriving_setup.on_fault.OnFaultInterface;
import com.spin.core.program_node.screwdriving_setup.on_fault.OnFaultText;
import com.spin.core.program_node.tool_action.ToolActionInterface;
import com.spin.core.program_node.tool_action.ToolActionService;
import com.spin.core.program_node.tool_action.ToolFunction;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.program.ProgramModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Length;
import org.jetbrains.annotations.NotNull;

public class OnFaultContribution
implements ProgramNodeContribution,
OnFaultInterface {
    private final ExtendedProgramAPIProvider apiProvider;

    public OnFaultContribution(@NotNull ExtendedProgramAPIProvider apiProvider) {
        this.apiProvider = apiProvider;
        ProgramModel programModel = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel();
        TreeNode root = programModel.getRootTreeNode((ProgramNodeContribution)this);
        try {
            URCapProgramNode moveNode = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getProgramNodeFactory().createURCapProgramNode(MoveDirectionService.class);
            URCapProgramNode toolActionNode = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getProgramNodeFactory().createURCapProgramNode(ToolActionService.class);
            root.addChild((ProgramNode)moveNode);
            root.addChild((ProgramNode)toolActionNode);
            ((MoveDirectionInterface)moveNode.getAs(MoveDirectionInterface.class)).setMoveDistance(apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().getSimpleValueFactory().createLength(50.0, Length.Unit.MM));
            ((ToolActionInterface)toolActionNode.getAs(ToolActionInterface.class)).selectFunction(ToolFunction.SAFETY_SHIELD_COVER_BIT);
        }
        catch (TreeStructureException e) {
            e.printStackTrace();
        }
    }

    public void openView() {
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.apiProvider.getTextResource().load(OnFaultText.ON_FAULT);
    }

    public boolean isDefined() {
        return true;
    }

    public void generateScript(ScriptWriter writer) {
        writer.appendLine("elif (screw_status == 3) :");
        writer.appendLine("sync()");
        writer.writeChildren();
        writer.appendLine("popup(error_message, error_title, error = True, blocking=True)");
        writer.appendLine("halt");
        writer.appendLine("end");
    }

    @Override
    public void writeTheScript(ScriptWriter writer) {
        this.generateScript(writer);
    }
}

