/*
 * Decompiled with CFR 0.152.
 */
package com.spin.api;

import com.spin.i18n.TextResource;
import com.spin.math.PoseMath;
import com.spin.ui.component.keypad.UnitKeypadFactory;
import com.spin.ui.unit.UnitConverter;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class ExtendedProgramAPIProvider {
    @NotNull
    private final ProgramAPIProvider programAPIProvider;

    public ExtendedProgramAPIProvider(@NotNull ProgramAPIProvider programAPIProvider) {
        this.programAPIProvider = programAPIProvider;
    }

    @NotNull
    public ProgramAPIProvider getProgramAPIProvider() {
        return this.programAPIProvider;
    }

    @NotNull
    public TextResource getTextResource() {
        Locale locale = this.programAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getLocale();
        return TextResource.defaultTextResource(locale);
    }

    @NotNull
    public UnitConverter getUnitConverter() {
        UnitType unitType = this.programAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getUnitType();
        SimpleValueFactory factory = this.programAPIProvider.getProgramAPI().getValueFactoryProvider().getSimpleValueFactory();
        return UnitConverter.create(unitType, factory);
    }

    public UnitKeypadFactory getUnitKeypadFactory() {
        KeyboardInputFactory factory = this.programAPIProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        return new UnitKeypadFactory(factory, this.getUnitConverter(), this.getTextResource());
    }

    @NotNull
    public PoseMath getPoseMath() {
        return new PoseMath(this.programAPIProvider.getProgramAPI().getValueFactoryProvider());
    }
}

