/*
 * Decompiled with CFR 0.152.
 */
package com.spin.model;

import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.device.Device;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.Rotation;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.AngularAcceleration;
import com.ur.urcap.api.domain.value.simple.AngularSpeed;
import com.ur.urcap.api.domain.value.simple.Current;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.urcap.api.domain.value.simple.Pressure;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.api.domain.value.simple.Time;
import com.ur.urcap.api.domain.value.simple.Torque;
import com.ur.urcap.api.domain.value.simple.Voltage;
import com.ur.urcap.api.domain.variable.Variable;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrefixedDataModel
implements DataModel {
    @NotNull
    private final DataModel model;
    @NotNull
    private final String prefix;

    public PrefixedDataModel(@NotNull DataModel internalModel, @NotNull String prefix) {
        PrefixedDataModel.throwIfNullOrEmpty(prefix);
        this.model = internalModel;
        this.prefix = prefix;
    }

    private static void throwIfNullOrEmpty(@NotNull String key) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("An empty string is not allowed as prefix");
        }
    }

    @Nullable
    private String addPrefixIfValid(@Nullable String key) {
        if (key != null && !key.isEmpty()) {
            key = this.prefix + key;
        }
        return key;
    }

    public void set(String key, boolean value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public boolean get(String key, boolean defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, int value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public int get(String key, int defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, long value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public long get(String key, long defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, float value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public float get(String key, float defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, double value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public double get(String key, double defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, String value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public String get(String key, String defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, JointPositions value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public JointPositions get(String key, JointPositions defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Variable value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Variable get(String key, Variable defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Acceleration value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Acceleration get(String key, Acceleration defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Angle value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Angle get(String key, Angle defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, AngularAcceleration value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public AngularAcceleration get(String key, AngularAcceleration defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, AngularSpeed value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public AngularSpeed get(String key, AngularSpeed defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Current value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Current get(String key, Current defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Force value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Force get(String key, Force defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Length value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Length get(String key, Length defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Mass value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Mass get(String key, Mass defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Pose value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Pose get(String key, Pose defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Position value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Position get(String key, Position defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Pressure value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Pressure get(String key, Pressure defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Rotation value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Rotation get(String key, Rotation defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Speed value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Speed get(String key, Speed defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Time value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Time get(String key, Time defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Torque value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Torque get(String key, Torque defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Voltage value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Voltage get(String key, Voltage defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, boolean[] value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public boolean[] get(String key, boolean[] defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, int[] value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public int[] get(String key, int[] defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, long[] value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public long[] get(String key, long[] defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, float[] value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public float[] get(String key, float[] defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, double[] value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public double[] get(String key, double[] defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, String[] value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public String[] get(String key, String[] defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, TCP value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public TCP get(String key, TCP defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Feature value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Feature get(String key, Feature defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Payload value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public Payload get(String key, Payload defaultValue) {
        return this.model.get(this.addPrefixIfValid(key), defaultValue);
    }

    public void set(String key, Device value) {
        this.model.set(this.addPrefixIfValid(key), value);
    }

    public <T extends Device> T get(String key, T defaultValue, Class<T> deviceClassType) {
        return (T)this.model.get(this.addPrefixIfValid(key), defaultValue, deviceClassType);
    }

    public Set<String> getKeys() {
        Predicate<String> startWithPrefix = key -> key.startsWith(this.prefix);
        Function<String, String> stripKey = key -> key.substring(this.prefix.length());
        return this.model.getKeys().stream().filter(startWithPrefix).map(stripKey).collect(Collectors.toSet());
    }

    public boolean isSet(String key) {
        return this.model.isSet(this.addPrefixIfValid(key));
    }

    public boolean remove(String key) {
        return this.model.remove(this.addPrefixIfValid(key));
    }
}

