/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.installation_node;

import com.spin.urcap.impl.daemons.xmlrpc.ModbusConnectionTask;
import com.spin.urcap.impl.daemons.xmlrpc.Tool2;
import com.spin.urcap.impl.daemons.xmlrpc.XMLRPCClient;
import com.spin.urcap.impl.daemons.xmlrpc.XMLRPCModbusServer;
import com.spin.urcap.impl.installation_node.InstallationView;
import com.spin.urcap.impl.installation_node.Stoppable;
import com.spin.urcap.impl.installation_node.bit_change.BitChangeTabContribution;
import com.spin.urcap.impl.installation_node.bit_change.BitChangeTabView;
import com.spin.urcap.impl.installation_node.feeder.FeederContribution;
import com.spin.urcap.impl.installation_node.feeder.FeederView;
import com.spin.urcap.impl.installation_node.settings.SettingsTabContribution;
import com.spin.urcap.impl.installation_node.settings.SettingsTabView;
import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.util.SWVersion;
import com.spin.urcap.impl.util.SpinUnits;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.contribution.installation.CreationContext;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.function.FunctionModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.tcp.TCPContributionModel;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class InstallationContribution
implements InstallationNodeContribution,
Stoppable {
    private static final long MODBUS_CONNECTION_TASK_PERIOD_MS = 5000L;
    private static final String[] bridgeIp = new String[]{"No ip configured"};
    private static SpinUnits spinUnits = null;
    public final PoseFactory poseFactory;
    private final InstallationView view;
    private final SettingsTabView settingsTabView;
    private final SettingsTabContribution settingsTabContribution;
    private final BitChangeTabView bitChangeTabView;
    private final BitChangeTabContribution bitChangeTabContribution;
    private final FeederView feederView;
    private final FeederContribution feederContribution;
    private final boolean validSoftwareVersion;
    private int currentOpenedTabIndex = -1;
    private final Tool2 tool2;
    private final ModbusConnectionTask modbusConnectionTask;
    private static final ScheduledExecutorService modbusConnectionTaskExecutor = Executors.newSingleThreadScheduledExecutor();
    private static final ExecutorService robotStateExecutor = Executors.newSingleThreadExecutor();

    public InstallationContribution() {
        this.view = null;
        this.settingsTabView = null;
        this.settingsTabContribution = null;
        this.bitChangeTabView = null;
        this.bitChangeTabContribution = null;
        this.feederView = null;
        this.feederContribution = null;
        this.poseFactory = null;
        this.tool2 = null;
        this.modbusConnectionTask = null;
        this.validSoftwareVersion = false;
    }

    public InstallationContribution(InstallationAPIProvider apiProvider, DataModel model, InstallationView view, CreationContext context) throws MalformedURLException {
        this.poseFactory = apiProvider.getInstallationAPI().getValueFactoryProvider().getPoseFactory();
        this.view = view;
        spinUnits = new SpinUnits(apiProvider, new LanguagePack(apiProvider.getSystemAPI().getSystemSettings().getLocalization()));
        this.validSoftwareVersion = new SWVersion(apiProvider).check();
        try {
            new XMLRPCModbusServer(40722).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XMLRPCClient xmlrpcClient = new XMLRPCClient();
        xmlrpcClient.connect(xmlrpcClient.getDHCP(), 1502);
        this.modbusConnectionTask = new ModbusConnectionTask();
        modbusConnectionTaskExecutor.scheduleAtFixedRate(this.modbusConnectionTask, 0L, 5000L, TimeUnit.MILLISECONDS);
        this.tool2 = new Tool2(apiProvider.getInstallationAPI().getIOModel());
        this.createCustomTCPs(apiProvider);
        FunctionModel functionModel = apiProvider.getInstallationAPI().getFunctionModel();
        try {
            functionModel.addFunction("spin_ss_command", new String[]{"command", "position"});
            functionModel.addFunction("spin_reset_errors", new String[0]);
            functionModel.addFunction("spin_motor_start", new String[]{"direction", "speed"});
            functionModel.addFunction("spin_motor_stop", new String[0]);
            functionModel.addFunction("spin_ss_stop", new String[0]);
            functionModel.addFunction("spin_led_intensity", new String[]{"intensity"});
            functionModel.addFunction("spin_ss_home", new String[0]);
            functionModel.addFunction("spin_ss_robot_follow", new String[0]);
            functionModel.addFunction("spin_ss_move_screw_cover", new String[]{"screwLength"});
            functionModel.addFunction("spin_ss_move_bit_cover", new String[0]);
            functionModel.addFunction("spin_ss_move_bit_release", new String[0]);
            functionModel.addFunction("spin_ss_move_home", new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.settingsTabView = this.view.getSettingsTabView();
        this.settingsTabContribution = new SettingsTabContribution(apiProvider, this.settingsTabView, model);
        this.bitChangeTabView = this.view.getBitChangeTabView();
        this.bitChangeTabContribution = new BitChangeTabContribution(apiProvider, this.bitChangeTabView, model, context);
        this.feederView = this.view.getDispenserTabView();
        this.feederContribution = new FeederContribution(apiProvider, this.feederView, model);
        if (context.getNodeCreationType() == CreationContext.NodeCreationType.NEW) {
            this.settingsTabContribution.initDataModel();
            this.bitChangeTabContribution.initDataModel();
            this.feederContribution.initDataModel();
        }
        this.updateBridgeIp(this.settingsTabContribution.getBridgeIP());
    }

    public static String getStaticBridgeIp() {
        return bridgeIp[0];
    }

    public void updateBridgeIp(String ip) {
        InstallationContribution.bridgeIp[0] = ip;
    }

    public SettingsTabContribution getSettingsTabContribution() {
        return this.settingsTabContribution;
    }

    public BitChangeTabContribution getMountingTabContribution() {
        return this.bitChangeTabContribution;
    }

    public FeederContribution getFeederTabContribution() {
        return this.feederContribution;
    }

    public void openView() {
        if (this.validSoftwareVersion) {
            this.openTab();
        }
    }

    public void closeView() {
        this.closeTab();
        this.currentOpenedTabIndex = -1;
    }

    public void openTab() {
        if (this.view.getOpenedTabIndex() == this.currentOpenedTabIndex) {
            return;
        }
        this.closeTab();
        this.currentOpenedTabIndex = this.view.getOpenedTabIndex();
        if (this.currentOpenedTabIndex == this.settingsTabView.getIndex()) {
            this.settingsTabContribution.openView();
            return;
        }
        if (this.currentOpenedTabIndex == this.bitChangeTabView.getIndex()) {
            this.bitChangeTabContribution.openView();
            return;
        }
        if (this.currentOpenedTabIndex == this.feederView.getIndex()) {
            this.feederContribution.openView();
        }
    }

    public void closeTab() {
        if (this.currentOpenedTabIndex == this.settingsTabView.getIndex()) {
            this.settingsTabContribution.closeView();
        } else if (this.currentOpenedTabIndex == this.bitChangeTabView.getIndex()) {
            this.bitChangeTabContribution.closeView();
        } else if (this.currentOpenedTabIndex == this.feederView.getIndex()) {
            this.feederContribution.closeView();
        }
    }

    private void ScriptToScriptParser(InputStream inputStream, ScriptWriter writer) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = br.readLine()) != null) {
                writer.appendLine(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generateScript(ScriptWriter writer) {
        InputStream inStream = this.getClass().getResourceAsStream("/com/spin/urcap/URScript/ScrewdriverFunctions.script");
        this.ScriptToScriptParser(inStream, writer);
        writer.appendLine("global rpc = rpc_factory(\"xmlrpc\", \"http://127.0.0.1:40722/RPC2\")");
    }

    public SpinUnits getSpinUnits() {
        return spinUnits;
    }

    public Tool2 getTool2() {
        return this.tool2;
    }

    @Override
    public void stop() {
        this.tool2.stop();
        modbusConnectionTaskExecutor.shutdownNow();
    }

    public void createCustomTCPs(InstallationAPIProvider apiProvider) {
        TCPContributionModel tcpContributionModel = apiProvider.getInstallationAPI().getTCPContributionModel();
        String TCP_SD35_KEY = "TCP_SD35";
        String TCP_SD70_KEY = "TCP_SD70";
        Pose TCP_SD35 = this.poseFactory.createPose(0.0, -248.6, 106.6, 90.0, 0.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
        Pose TCP_SD70 = this.poseFactory.createPose(0.0, -262.6, 106.6, 90.0, 0.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
        if (tcpContributionModel.getTCP("TCP_SD35") == null) {
            tcpContributionModel.addTCP("TCP_SD35", "SpinSD35", TCP_SD35);
        }
        if (tcpContributionModel.getTCP("TCP_SD70") == null) {
            tcpContributionModel.addTCP("TCP_SD70", "SpinSD70", TCP_SD70);
        }
    }
}

