/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.util;

import java.io.Serializable;
import java.util.Objects;

public class ScrewProgram
implements Serializable {
    public static final int TYPE_EXTRACTION = 1;
    public static final int TYPE_POSITION = 2;
    public static final int TYPE_TORQUE = 3;
    public int id = -1;
    public int direction = -1;
    public String name = "";
    public Screw screw = new Screw();
    public double targetAngle = -1.0;
    public double targetPosition = -1.0;
    public double targetTorque = -1.0;
    public double targetDev = -1.0;
    public int typeId = -1;
    public int childId = -1;
    public int parentId = -1;

    public String toStringComplete() {
        return "(id: " + this.id + ", direction: " + (this.direction == 0 ? "CW" : "CCW") + ", name: " + this.name + ", targetAngle: " + this.targetAngle + ", targetPosition: " + this.targetPosition + ", targetTorque: " + this.targetTorque + ", targetDev: " + this.targetDev + ", typeId: " + this.typeId + ", parentId: " + this.parentId + ", childId: " + this.childId + ", screw: " + this.screw + ")";
    }

    public String toString() {
        return this.name;
    }

    public ScrewProgram() {
    }

    public ScrewProgram(String name) {
        this.name = name;
    }

    public ScrewProgram(int id, int direction, String name, Screw screw, double targetAngle, double targetPosition, double targetTorque, double targetDev, int typeId, int childId, int parentId) {
        this.id = id;
        this.direction = direction;
        this.name = name;
        this.screw = screw;
        this.targetAngle = targetAngle;
        this.targetPosition = targetPosition;
        this.targetTorque = targetTorque;
        this.targetDev = targetDev;
        this.typeId = typeId;
        this.childId = childId;
        this.parentId = parentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScrewProgram screwProgram = (ScrewProgram)o;
        return this.id == screwProgram.id && this.direction == screwProgram.direction && Double.compare(screwProgram.targetAngle, this.targetAngle) == 0 && Double.compare(screwProgram.targetPosition, this.targetPosition) == 0 && Double.compare(screwProgram.targetTorque, this.targetTorque) == 0 && Double.compare(screwProgram.targetDev, this.targetDev) == 0 && this.typeId == screwProgram.typeId && this.childId == screwProgram.childId && this.parentId == screwProgram.parentId && this.name.equals(screwProgram.name) && this.screw.equals(screwProgram.screw);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.direction, this.name, this.screw, this.targetAngle, this.targetPosition, this.targetTorque, this.targetDev, this.typeId, this.childId, this.parentId);
    }

    public static class Screw
    implements Serializable {
        public int typeId;
        public double length;
        public double washerThickness;

        public Screw() {
        }

        public Screw(int typeId, double length, double washerThickness) {
            this.typeId = typeId;
            this.length = length;
            this.washerThickness = washerThickness;
        }

        public String toString() {
            return "(typeId: " + this.typeId + ", length: " + this.length + ", washerThickness: " + this.washerThickness + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Screw screw = (Screw)o;
            return this.typeId == screw.typeId && Double.compare(screw.length, this.length) == 0 && Double.compare(screw.washerThickness, this.washerThickness) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.typeId, this.length, this.washerThickness);
        }
    }
}

