/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.move_to_screw;

import com.spin.core.program_node.move_to_screw.MoveToScrewContribution;
import com.spin.core.program_node.move_to_screw.MoveToScrewText;
import com.spin.ui.callback.OnMovementCompleteCallback;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovement;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveToScrewVerifyPositionView {
    @NotNull
    private final JButton moveAboveScrewButton;
    @NotNull
    private final JButton moveToScrewButton;
    @NotNull
    private final JButton cancelButton;
    @Nullable
    private Pose aboveScrewPose = null;
    @Nullable
    private Pose atScrewPose = null;

    MoveToScrewVerifyPositionView(@NotNull ExtendedViewAPIProvider apiProvider) {
        TextResource textResource = apiProvider.getTextResource();
        ImageIcon moveIcon = UR_Icon.MOVE.load();
        ImageIcon cancelIcon = UR_Icon.CANCEL.load();
        this.moveAboveScrewButton = new ButtonMedium(textResource.load(MoveToScrewText.MOVE_ABOVE_SCREW), moveIcon);
        this.moveToScrewButton = new ButtonMedium(textResource.load(MoveToScrewText.MOVE_TO_SCREW), moveIcon);
        this.cancelButton = new ButtonMedium(textResource.load(MoveToScrewText.CANCEL), cancelIcon);
    }

    @NotNull
    JPanel createPanel() {
        JPanel panel = new JPanel((LayoutManager)UR_MigLayout.equalColumns(12, 10, "push[]10[]push[]push"));
        panel.add((Component)this.moveAboveScrewButton, "cell 1 0, span 6, grow");
        panel.add((Component)this.moveToScrewButton, "cell 1 1, span 6, grow");
        panel.add((Component)this.cancelButton, "cell 2 2, span 3, grow");
        return panel;
    }

    void registerListeners(@NotNull ContributionProvider<MoveToScrewContribution> provider) {
        this.moveAboveScrewButton.addActionListener(event -> this.moveAboveScrew((MoveToScrewContribution)provider.get()));
        this.moveToScrewButton.addActionListener(event -> this.moveToScrew((MoveToScrewContribution)provider.get()));
        this.cancelButton.addActionListener(event -> ((MoveToScrewContribution)provider.get()).onExitVerifyPosition());
    }

    void resetWithPoses(@NotNull Pose aboveScrewPose, @NotNull Pose atScrewPose) {
        this.aboveScrewPose = aboveScrewPose;
        this.atScrewPose = atScrewPose;
        this.moveToScrewButton.setEnabled(false);
    }

    private void moveAboveScrew(@NotNull MoveToScrewContribution contribution) {
        assert (this.aboveScrewPose != null);
        RobotMovement robotMovement = contribution.getUserInteraction().getRobotMovement();
        robotMovement.requestUserToMoveRobot(this.aboveScrewPose, (RobotMovementCallback)new OnMovementCompleteCallback(() -> this.moveToScrewButton.setEnabled(true)));
    }

    private void moveToScrew(@NotNull MoveToScrewContribution contribution) {
        assert (this.atScrewPose != null);
        RobotMovement robotMovement = contribution.getUserInteraction().getRobotMovement();
        robotMovement.requestUserToMoveRobot(this.atScrewPose, (RobotMovementCallback)new OnMovementCompleteCallback(contribution::onExitVerifyPosition));
    }
}

