/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.tcp_payload;

import com.spin.core.installation_node.tcp_payload.Tool;
import com.spin.core.installation_node.tcp_payload.ToolSpecs;
import com.ur.urcap.api.domain.payload.PayloadContributionModel;
import com.ur.urcap.api.domain.tcp.TCPContributionModel;
import org.jetbrains.annotations.NotNull;

public class TCPAndPayloadRegistration {
    public static void addAllNewTCPs(@NotNull TCPContributionModel model, @NotNull ToolSpecs specs) {
        for (Tool tool : Tool.values()) {
            TCPAndPayloadRegistration.addTCPIfNotAlreadyAdded(model, specs, tool);
        }
    }

    public static void addAllNewPayloads(@NotNull PayloadContributionModel model, @NotNull ToolSpecs specs) {
        for (Tool tool : Tool.values()) {
            TCPAndPayloadRegistration.addPayloadIfNotAlreadyAdded(model, specs, tool);
        }
    }

    private static void addTCPIfNotAlreadyAdded(@NotNull TCPContributionModel model, @NotNull ToolSpecs specs, @NotNull Tool tool) {
        String id = specs.id(tool);
        if (model.getTCP(id) == null) {
            model.addTCP(id, specs.tcpName(tool), specs.tcpPose(tool));
        }
    }

    private static void addPayloadIfNotAlreadyAdded(@NotNull PayloadContributionModel model, @NotNull ToolSpecs specs, @NotNull Tool tool) {
        String id = specs.id(tool);
        if (model.getPayload(id) == null) {
            model.addPayload(specs.id(tool), specs.payloadName(tool), specs.mass(tool), specs.cogPosition(tool));
        }
    }
}

