/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.discovery;

import com.spin.bridge_communication.URCapInterfaceProvider;
import com.spin.bridge_communication.discovery.MulticastReceiverTask;
import com.spin.bridge_communication.discovery.UpdateSpinBridgesTask;
import com.spin.domain.DiscoveredBridge;
import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class BridgeDiscovery {
    private static final Duration bridgeExpirationTime = Duration.ofSeconds(5L);
    private static final String MULTICAST_GROUP_ADDRESS = "224.0.0.37";
    private static final int MULTICAST_GROUP_PORT = 5037;
    private static final long UPDATE_SPIN_BRIDGES_INTERVAL_MILLIS = 2000L;
    @NotNull
    private final BlockingQueue<DiscoveredBridge> bridgeQueue;
    @NotNull
    private final HashMap<InetAddress, DiscoveredBridge> onlineBridges;
    @NotNull
    private final URCapInterfaceProvider interfaceProvider;

    public BridgeDiscovery(@NotNull URCapInterfaceProvider interfaceProvider) {
        this.interfaceProvider = interfaceProvider;
        this.bridgeQueue = new LinkedBlockingDeque<DiscoveredBridge>(100);
        this.onlineBridges = new HashMap();
        UpdateSpinBridgesTask updateSpinBridgesTask = new UpdateSpinBridgesTask(this);
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.scheduleAtFixedRate(updateSpinBridgesTask, 0L, 2000L, TimeUnit.MILLISECONDS);
        MulticastReceiverTask multicastReceiverTask = null;
        try {
            multicastReceiverTask = new MulticastReceiverTask(this, InetAddress.getByName(MULTICAST_GROUP_ADDRESS), 5037);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        assert (multicastReceiverTask != null);
        executorService.execute(multicastReceiverTask);
    }

    public void onOnlineSpinBridgesUpdated() {
        this.interfaceProvider.getDiscoveryConsumer().process(this.onlineBridges());
    }

    @NotNull
    public ArrayList<DiscoveredBridge> onlineBridges() {
        return new ArrayList<DiscoveredBridge>(this.onlineBridges.values());
    }

    protected int drainQueue() {
        ArrayList<DiscoveredBridge> bridges = new ArrayList<DiscoveredBridge>();
        this.bridgeQueue.drainTo(bridges);
        return this.addOnlineBridges(bridges);
    }

    protected void enqueue(@NotNull DiscoveredBridge bridge) {
        this.bridgeQueue.offer(bridge);
    }

    protected int expireSpinBridges() {
        LocalDateTime now = LocalDateTime.now();
        Set<InetAddress> ips = this.onlineBridges.keySet();
        HashSet<InetAddress> toBeRemoved = new HashSet<InetAddress>();
        for (InetAddress ip : ips) {
            LocalDateTime lastSeen = this.onlineBridges.get(ip).lastSeen();
            int diff = Duration.between(lastSeen, now).compareTo(bridgeExpirationTime);
            if (diff <= 0) continue;
            toBeRemoved.add(ip);
        }
        for (InetAddress ip : toBeRemoved) {
            this.onlineBridges.remove(ip);
        }
        return toBeRemoved.size();
    }

    private int addOnlineBridges(@NotNull ArrayList<DiscoveredBridge> bridges) {
        int put = 0;
        for (DiscoveredBridge bridge : bridges) {
            if (this.onlineBridges.put(bridge.ip(), bridge) != null) continue;
            ++put;
        }
        return put;
    }
}

