/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.toolbar.internal;

import com.spin.domain.DataTrace;
import com.spin.ui.urstyle.UR_Color;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Stroke;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ResultChart {
    @NotNull
    private final ChartPanel chartPanel = ResultChart.createEmptyChartPanel();

    @NotNull
    static ChartPanel createEmptyChartPanel() {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesPaint(0, (Paint)UR_Color.RED);
        renderer.setSeriesShapesVisible(0, false);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        XYPlot plot = chart.getXYPlot();
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)UR_Color.WHITE);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)UR_Color.BLACK);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)UR_Color.BLACK);
        return new ChartPanel(chart);
    }

    @NotNull
    private static XYSeries asSeries(@NotNull DataTrace trace) {
        XYSeries series = new XYSeries((Comparable)((Object)"Name"));
        float[] data = trace.getTrace();
        for (int i = 0; i < data.length; ++i) {
            series.add((double)i / (double)trace.getSampleRate(), (double)data[i]);
        }
        return series;
    }

    @NotNull
    public JComponent getViewComponent() {
        return this.chartPanel;
    }

    public void plotTrace(@Nullable DataTrace trace, @Nullable String xLabel, @Nullable String yLabel) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        if (trace != null) {
            dataset.addSeries(ResultChart.asSeries(trace));
        }
        XYPlot plot = this.chartPanel.getChart().getXYPlot();
        plot.setDataset((XYDataset)dataset);
        plot.getDomainAxis().setLabel(xLabel);
        plot.getRangeAxis().setLabel(yLabel);
    }
}

