/*
 * Decompiled with CFR 0.152.
 */
package com.spin.stream;

import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Filter {
    @NotNull
    public static <T> Predicate<? super T> takeWhile(final @NotNull Predicate<T> predicate) {
        return new Predicate<T>(){
            boolean takeElement = true;

            @Override
            public boolean test(T element) {
                if (!predicate.test(element)) {
                    this.takeElement = false;
                }
                return this.takeElement;
            }
        };
    }

    @NotNull
    public static <T> Predicate<? super T> dropWhile(final @NotNull Predicate<T> predicate) {
        return new Predicate<T>(){
            boolean takeElement = false;

            @Override
            public boolean test(T element) {
                if (!predicate.test(element)) {
                    this.takeElement = true;
                }
                return this.takeElement;
            }
        };
    }

    @NotNull
    public static <T> Predicate<? super T> takeAfter(final @NotNull Predicate<T> predicate) {
        return new Predicate<T>(){
            boolean takeElement = false;

            @Override
            public boolean test(T element) {
                boolean takeThis = this.takeElement;
                if (predicate.test(element)) {
                    this.takeElement = true;
                }
                return takeThis;
            }
        };
    }

    @NotNull
    public static <T> Predicate<? super T> dropAfter(final @NotNull Predicate<T> predicate) {
        return new Predicate<T>(){
            boolean takeElement = true;

            @Override
            public boolean test(T element) {
                boolean takeThis = this.takeElement;
                if (predicate.test(element)) {
                    this.takeElement = false;
                }
                return takeThis;
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Predicate<? super T> take(int n) {
        int[] count = new int[]{0};
        return element -> {
            int n2 = count[0];
            count[0] = n2 + 1;
            return n2 < n;
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Predicate<? super T> drop(int n) {
        int[] count = new int[]{0};
        return element -> {
            int n2 = count[0];
            count[0] = n2 + 1;
            return n2 >= n;
        };
    }
}

