/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.toolbar;

import com.spin.core.toolbar.ToolbarText;
import com.spin.core.toolbar.internal.ResultChart;
import com.spin.core.toolbar.internal.ResultTable;
import com.spin.domain.ProgramResult;
import com.spin.domain.program_goal.CrossTighteningGoal;
import com.spin.domain.program_goal.PositionGoal;
import com.spin.domain.program_goal.PrePlacedTorqueGoal;
import com.spin.domain.program_goal.ProgramGoal;
import com.spin.domain.program_goal.TorqueGoal;
import com.spin.i18n.TextResource;
import com.spin.ui.component.ButtonSmall;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.ui.unit.UnitConverter;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolbarDataTableView {
    @NotNull
    private final Icon successIcon = UR_Icon.APPROVE_SMALL.load();
    @NotNull
    private final Icon failIcon = UR_Icon.CANCEL_SMALL.load();
    @NotNull
    private final ResultTable<ProgramResult> resultTable;
    @NotNull
    private final ResultChart resultChart;
    @NotNull
    private final ButtonSmall returnButton;
    @NotNull
    private final JComponent chartContainer;
    @NotNull
    private final UnitConverter unitConverter;
    @NotNull
    private final String xAxisLabel;
    @NotNull
    private final String yAxisDepthLabel;
    @NotNull
    private final String yAxisTorqueLabel;

    ToolbarDataTableView(@NotNull TextResource textResource, @NotNull UnitConverter unitConverter) {
        this.unitConverter = unitConverter;
        this.xAxisLabel = textResource.load(ToolbarText.TIME) + " [s]";
        this.yAxisDepthLabel = textResource.load(ToolbarText.INSERTION_DEPTH) + " [mm]";
        this.yAxisTorqueLabel = textResource.load(ToolbarText.TORQUE) + " [Nm]";
        String timeTitle = textResource.load(ToolbarText.TIME);
        String goalTitle = textResource.load(ToolbarText.GOAL);
        String finalTitle = textResource.load(ToolbarText.FINAL);
        String successTitle = textResource.load(ToolbarText.SUCCESS);
        this.resultTable = new ResultTable<ProgramResult>(8, this::extractRowData, new ResultTable.Column(timeTitle, 1), new ResultTable.Column(goalTitle), new ResultTable.Column(finalTitle), new ResultTable.Column(successTitle, Icon.class, 1));
        this.resultChart = new ResultChart();
        this.returnButton = new ButtonSmall(textResource.load(ToolbarText.RETURN));
        this.chartContainer = ToolbarDataTableView.createChartContainer(this.resultChart, this.returnButton);
    }

    @NotNull
    private static JComponent createChartContainer(@NotNull ResultChart resultChart, @NotNull ButtonSmall returnButton) {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)UR_MigLayout.singleColumn(5, "[][]"));
        panel.add((Component)resultChart.getViewComponent(), "cell 0 0, grow");
        panel.add((Component)returnButton, "cell 0 1, center");
        return panel;
    }

    public void buildUI(@NotNull JPanel panel) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 5, "[]"));
        panel.add((Component)this.chartContainer, "cell 0 0, span 12, hidemode 3");
        panel.add((Component)this.resultTable.getViewComponent(), "cell 1 0, span 10, grow, hidemode 3");
        this.setChartVisible(false);
        this.registerListeners();
    }

    private void registerListeners() {
        this.resultTable.addResultClickListener(result -> {
            this.plotResult((ProgramResult)result);
            this.setChartVisible(true);
        });
        this.returnButton.addActionListener(event -> this.setChartVisible(false));
    }

    private void setChartVisible(boolean visible) {
        this.chartContainer.setVisible(visible);
        this.resultTable.getViewComponent().setVisible(!visible);
    }

    void addNewResult(@NotNull ProgramResult result) {
        if (result.getInsertionDepthTrace().getSampleRate() == 0) {
            return;
        }
        this.resultTable.addNewResult(result);
    }

    private void plotResult(@NotNull ProgramResult result) {
        if (result.getGoal() instanceof PositionGoal) {
            this.resultChart.plotTrace(result.getInsertionDepthTrace(), this.xAxisLabel, this.yAxisDepthLabel);
        } else {
            this.resultChart.plotTrace(result.getTorqueTrace(), this.xAxisLabel, this.yAxisTorqueLabel);
        }
    }

    @NotNull
    private Object[] extractRowData(@NotNull ProgramResult result) {
        return new Object[]{this.formatTimestampCellValue(result.getTime()), this.formatUnitCellValue(this.extractTargetMetric(result)), this.formatUnitCellValue(this.extractActualMetric(result)), this.formatSuccessCellValue(result.isSuccess())};
    }

    @Nullable
    private Object extractTargetMetric(@NotNull ProgramResult result) {
        ProgramGoal goal = result.getGoal();
        if (goal instanceof PositionGoal) {
            return ((PositionGoal)goal).targetInsertionDepth();
        }
        if (goal instanceof TorqueGoal) {
            return ((TorqueGoal)goal).targetTorque();
        }
        if (goal instanceof CrossTighteningGoal) {
            return ((CrossTighteningGoal)goal).targetTorque();
        }
        if (goal instanceof PrePlacedTorqueGoal) {
            return ((PrePlacedTorqueGoal)goal).targetTorque();
        }
        return null;
    }

    @Nullable
    private Object extractActualMetric(@NotNull ProgramResult result) {
        ProgramGoal goal = result.getGoal();
        if (goal instanceof PositionGoal) {
            return result.getFinalInsertionDepth();
        }
        if (goal instanceof TorqueGoal) {
            return result.getFinalTorque();
        }
        if (goal instanceof CrossTighteningGoal) {
            return result.getFinalTorque();
        }
        if (goal instanceof PrePlacedTorqueGoal) {
            return result.getFinalTorque();
        }
        return null;
    }

    @Nullable
    private String formatTimestampCellValue(@Nullable LocalDateTime time) {
        return time == null ? null : time.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    @Nullable
    private <T> String formatUnitCellValue(@Nullable T unit) {
        if (unit == null) {
            return null;
        }
        Class<?> clazz = unit.getClass();
        DecimalFormat format = new DecimalFormat("0.00");
        return format.format(this.unitConverter.valueOf(clazz, unit)) + " " + this.unitConverter.labelOf(clazz);
    }

    @NotNull
    private Icon formatSuccessCellValue(boolean success) {
        return success ? this.successIcon : this.failIcon;
    }
}

