/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.unload_screw;

import com.spin.api.ExtendedProgramAPIProvider;
import com.spin.core.installation_node.InstallationContribution;
import com.spin.domain.ScrewFeeder;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.value.Pose;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnloadScrewData {
    @NotNull
    private final DataModel dataModel;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final InstallationContribution installationContribution;

    UnloadScrewData(@NotNull DataModel dataModel, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.dataModel = dataModel;
        this.undoRedoManager = apiProvider.getProgramAPIProvider().getProgramAPI().getUndoRedoManager();
        this.installationContribution = (InstallationContribution)apiProvider.getProgramAPIProvider().getProgramAPI().getInstallationNode(InstallationContribution.class);
    }

    boolean isValidConfiguration() {
        return this.selectedScrewFeeder() != null && this.getPose() != null;
    }

    @Nullable
    UUID selectedScrewFeederId() {
        String selectedScrewFeederId = this.dataModel.get("screwFeeder", (String)null);
        if (selectedScrewFeederId != null) {
            return UUID.fromString(selectedScrewFeederId);
        }
        return null;
    }

    @Nullable
    ScrewFeeder selectedScrewFeeder() {
        UUID selectedScrewFeederId = this.selectedScrewFeederId();
        Set<ScrewFeeder> feeders = this.installationContribution.getScrewFeeders();
        return feeders.stream().filter(feeder -> feeder.id().equals(selectedScrewFeederId)).findFirst().orElse(null);
    }

    void setSelectedScrewFeeder(@NotNull ScrewFeeder screwFeeder) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("screwFeeder", screwFeeder.id().toString()));
    }

    boolean approachEnabled() {
        return this.dataModel.get("approachEnabled", true);
    }

    void setApproachEnabled(boolean enabled) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("approachEnabled", enabled));
    }

    public boolean departEnabled() {
        return this.dataModel.get("departEnabled", true);
    }

    void setDepartEnabled(boolean enabled) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("departEnabled", enabled));
    }

    void setPose(Pose pose) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("pose", pose));
    }

    Pose getPose() {
        return this.dataModel.get("pose", (Pose)null);
    }
}

