/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.tool_action;

import com.spin.core.program_node.tool_action.ToolFunction;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.value.ValueFactoryProvider;
import com.ur.urcap.api.domain.value.simple.Length;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolActionData {
    @NotNull
    private final DataModel dataModel;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final ValueFactoryProvider valueFactoryProvider;
    @NotNull
    private final ToolFunction[] noArgumentList = new ToolFunction[]{ToolFunction.ACKNOWLEDGE_ERRORS, ToolFunction.SAFETY_SHIELD_COVER_BIT, ToolFunction.SAFETY_SHIELD_DO_HOMING, ToolFunction.SAFETY_SHIELD_FOLLOW_ROBOT, ToolFunction.SAFETY_SHIELD_LOCK_BIT, ToolFunction.SAFETY_SHIELD_RELEASE_BIT, ToolFunction.SAFETY_SHIELD_STOP, ToolFunction.STOP_MOTOR};
    @NotNull
    private final ToolFunction[] screwLengthArgumentList = new ToolFunction[]{ToolFunction.SAFETY_SHIELD_COVER_SCREW};
    @NotNull
    private final ToolFunction[] absolutePositionArgumentList = new ToolFunction[]{ToolFunction.SAFETY_SHIELD_MOVE_TO_POSITION};
    @NotNull
    private final ToolFunction[] angularSpeedArgumentList = new ToolFunction[]{ToolFunction.START_MOTOR};

    ToolActionData(@NotNull DataModel dataModel, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.dataModel = dataModel;
        this.undoRedoManager = apiProvider.getProgramAPIProvider().getProgramAPI().getUndoRedoManager();
        this.valueFactoryProvider = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider();
    }

    @Nullable
    ToolFunction getFunction() {
        int selectedOrdinal = this.dataModel.get("function", -1);
        return selectedOrdinal == -1 ? null : ToolFunction.values()[selectedOrdinal];
    }

    void setFunction(@NotNull ToolFunction toolFunction) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("function", toolFunction.ordinal()));
    }

    @Nullable
    Length getScrewLength() {
        return this.dataModel.get("screw_length", (Length)null);
    }

    void setScrewLength(@NotNull Length screwLength) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("screw_length", screwLength));
    }

    @Nullable
    Length getAbsolutPosition() {
        return this.dataModel.get("absolute_position", (Length)null);
    }

    void setAbsolutePosition(@NotNull Length absolutePosition) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("absolute_position", absolutePosition));
    }

    boolean isValidConfiguration() {
        if (this.getFunction() != null) {
            if (this.takesNoArguments(this.getFunction())) {
                return true;
            }
            if (this.takesScrewLength(this.getFunction())) {
                return this.getScrewLength() != null;
            }
            if (this.takesAbsolutePosition(this.getFunction())) {
                return this.getAbsolutPosition() != null;
            }
            if (this.takesAngularSpeed(this.getFunction())) {
                return this.getAngularSpeed() != null;
            }
        }
        return false;
    }

    boolean takesAngularSpeed(ToolFunction function) {
        for (ToolFunction angularSpeedArg : this.angularSpeedArgumentList) {
            if (angularSpeedArg != function) continue;
            return true;
        }
        return false;
    }

    boolean takesAbsolutePosition(ToolFunction function) {
        for (ToolFunction absolutePositionArg : this.absolutePositionArgumentList) {
            if (absolutePositionArg != function) continue;
            return true;
        }
        return false;
    }

    boolean takesScrewLength(ToolFunction function) {
        for (ToolFunction screwLengthArg : this.screwLengthArgumentList) {
            if (screwLengthArg != function) continue;
            return true;
        }
        return false;
    }

    boolean takesNoArguments(ToolFunction selectedFunction) {
        for (ToolFunction noArg : this.noArgumentList) {
            if (noArg != selectedFunction) continue;
            return true;
        }
        return false;
    }

    @NotNull
    Length minAllowedScrewLength() {
        return this.valueFactoryProvider.getSimpleValueFactory().createLength(0.0, Length.Unit.MM);
    }

    @NotNull
    Length maxAllowedScrewLength() {
        return this.valueFactoryProvider.getSimpleValueFactory().createLength(56.0, Length.Unit.MM);
    }

    @NotNull
    Integer minAllowedRPM() {
        return -750;
    }

    @NotNull
    Integer maxAllowedRPM() {
        return 750;
    }

    @Nullable
    public Integer getAngularSpeed() {
        if (this.dataModel.isSet("angular_speed_rpm")) {
            return this.dataModel.get("angular_speed_rpm", 0);
        }
        return null;
    }

    public void setAngularSpeed(int angularSpeedRPM) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("angular_speed_rpm", angularSpeedRPM));
    }
}

