/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.component.keypad;

import com.spin.ui.component.keypad.UnitInputValidator;
import com.spin.ui.unit.UnitConverter;
import com.spin.util.math.UnitComparison;
import org.jetbrains.annotations.NotNull;

public class UnitRangeValidator<Number, Unit>
implements UnitInputValidator<Unit> {
    @NotNull
    private final UnitConverter unitConverter;
    @NotNull
    private final Class<Number> numberClass;
    @NotNull
    private final Class<Unit> unitClass;
    @NotNull
    private final Unit minValue;
    @NotNull
    private final Unit maxValue;
    @NotNull
    private final String errorMessage;
    private final double minBound;
    private final double maxBound;

    public UnitRangeValidator(@NotNull UnitConverter unitConverter, @NotNull Unit minValue, @NotNull Unit maxValue, @NotNull String errorMessage, @NotNull Class<Number> numberClass, @NotNull Class<Unit> unitClass) {
        this.unitConverter = unitConverter;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.errorMessage = errorMessage;
        this.numberClass = numberClass;
        this.unitClass = unitClass;
        this.minBound = this.ceilIfInteger(numberClass, unitConverter.valueOf(unitClass, minValue));
        this.maxBound = this.floorIfInteger(numberClass, unitConverter.valueOf(unitClass, maxValue));
        if (this.minBound > this.maxBound) {
            throw new IllegalArgumentException("minValue can not be greater than maxValue");
        }
    }

    private double ceilIfInteger(@NotNull Class<Number> numberClass, double value) {
        return numberClass == Integer.class ? Math.ceil(value) : value;
    }

    private double floorIfInteger(@NotNull Class<Number> numberClass, double value) {
        return numberClass == Integer.class ? Math.floor(value) : value;
    }

    @Override
    public boolean isValid(@NotNull Unit value) {
        return !UnitComparison.lessThan(value, this.minValue) && !UnitComparison.greaterThan(value, this.maxValue);
    }

    @Override
    @NotNull
    public String getMessage(@NotNull Unit value) {
        String label = this.unitConverter.labelOf(this.unitClass);
        return this.numberClass == Integer.class ? String.format(this.errorMessage, (int)this.minBound, label, (int)this.maxBound, label) : String.format(this.errorMessage, this.minBound, label, this.maxBound, label);
    }
}

