/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.component.keypad;

import com.spin.ui.component.keypad.UnitInputValidator;
import com.spin.ui.component.keypad.UnitKeypadCallback;
import com.spin.ui.component.keypad.WrappedUnitKeypadCallback;
import com.spin.ui.component.keypad.WrappedUnitValidator;
import com.spin.ui.unit.UnitConverter;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnitKeypad<Number, Unit> {
    @NotNull
    private final KeyboardNumberInput<Number> keyboard;
    @NotNull
    private final UnitConverter unitConverter;
    @NotNull
    private final Class<Number> numberClass;
    @NotNull
    private final Class<Unit> unitClass;

    UnitKeypad(@NotNull KeyboardNumberInput<Number> keyboard, @NotNull UnitConverter unitConverter, @NotNull Class<Number> numberClass, @NotNull Class<Unit> unitClass) {
        this.keyboard = keyboard;
        this.unitConverter = unitConverter;
        this.numberClass = numberClass;
        this.unitClass = unitClass;
    }

    public void setInitialValue(@Nullable Unit value) {
        if (value == null) {
            this.keyboard.setInitialValue(null);
        } else {
            double doubleValue = this.unitConverter.valueOf(this.unitClass, value);
            Number numberValue = this.roundIfIntegerKeyboard(doubleValue);
            this.keyboard.setInitialValue(numberValue);
        }
    }

    public void setErrorValidator(@NotNull UnitInputValidator<Unit> validator) {
        this.keyboard.setErrorValidator(new WrappedUnitValidator(validator, this.unitConverter, this.unitClass));
    }

    public void show(@NotNull JTextField component, @NotNull UnitKeypadCallback<Unit> unitKeypadCallback) {
        this.keyboard.show(component, new WrappedUnitKeypadCallback(unitKeypadCallback, this.unitConverter, this.unitClass));
    }

    public void show(@NotNull JLabel component, @NotNull UnitKeypadCallback<Unit> unitKeypadCallback) {
        this.keyboard.show(component, new WrappedUnitKeypadCallback(unitKeypadCallback, this.unitConverter, this.unitClass));
    }

    public void show(@NotNull JButton component, @NotNull UnitKeypadCallback<Unit> unitKeypadCallback) {
        this.keyboard.show(component, new WrappedUnitKeypadCallback(unitKeypadCallback, this.unitConverter, this.unitClass));
    }

    @NotNull
    private Number roundIfIntegerKeyboard(double value) {
        if (this.numberClass == Double.class) {
            return this.numberClass.cast(value);
        }
        if (this.numberClass == Integer.class) {
            return this.numberClass.cast(Math.toIntExact(Math.round(value)));
        }
        throw new IllegalStateException("Unknown type of number");
    }
}

