/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.program_nodes;

import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.localization.TextResource;
import com.spin.urcap.impl.program_nodes.InsertScrewProgramNodeContribution;
import com.spin.urcap.impl.util.ImageHelper;
import com.spin.urcap.impl.util.PopupTool;
import com.spin.urcap.impl.util.Product;
import com.spin.urcap.impl.util.ScrewProgram;
import com.spin.urcap.impl.util.swing.SwingAbstractStyle;
import com.spin.urcap.impl.util.swing.SwingStandards;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class InsertScrewProgramNodeView
implements SwingProgramNodeView<InsertScrewProgramNodeContribution> {
    private final JLabel forceInTCPZLabel = new JLabel();
    private final JLabel forceInTCPZUnitLabel = new JLabel();
    private final JTextField forceInTCPZ = new JTextField();
    private final JTextField s1Offset = new JTextField();
    private final JTextField s2Offset = new JTextField();
    private final JTextField maxVelocity = new JTextField();
    private final JLabel drawing = new JLabel();
    private final JLabel maxVelocityLabel = new JLabel();
    private final JLabel maxVelocityUnitLabel = new JLabel();
    private final JLabel s1offSetUnitLabel = new JLabel();
    private final JLabel s1offSetLabel = new JLabel();
    private final JLabel s2offSetUnitLabel = new JLabel();
    private final JLabel s2offSetLabel = new JLabel();
    private final JLabel S1;
    private final JLabel S2;
    private final SwingAbstractStyle style;
    private final JLabel lblSafetyWarning = new JLabel();
    private JButton setPoseBtn;
    private JButton moveHereBtn;
    private JButton infoBtn;
    private JPanel safetyPanel;
    private JPanel jPanel;
    private JPanel mainPanel;
    private JPanel bottomPanel;
    private JPanel infoPanel;
    private JCheckBox ckboxEnableSafety;
    private JCheckBox ckBoxExternalTarget;
    private boolean enableSafety = true;
    private JComboBox productComboBox;
    private JComboBox screwProgramComboBox;

    public InsertScrewProgramNodeView(SwingAbstractStyle style) {
        this.style = style;
        this.S1 = ImageHelper.loadImage("/com/spin/urcap/icons/offsetS1.jpg");
        this.S2 = ImageHelper.loadImage("/com/spin/urcap/icons/offsetS2.jpg");
    }

    public void buildUI(JPanel jPanel, final ContributionProvider<InsertScrewProgramNodeContribution> contributionProvider) {
        this.jPanel = jPanel;
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        this.mainPanel = new JPanel();
        this.bottomPanel = new JPanel(new BorderLayout());
        GroupLayout layout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        this.drawing.setIcon(this.S1.getIcon());
        JSeparator sep = new JSeparator(0);
        JSeparator sep2 = new JSeparator(0);
        Component productCB = this.createProductComboBox(contributionProvider);
        Component screwProgramCB = this.createScrewProgramComboBox(contributionProvider);
        this.createInfoButton();
        this.createInfoPanel(contributionProvider);
        JLabel lblProduct = new JLabel(this.getTextResource().insertScrewProduct());
        lblProduct.setFont(lblProduct.getFont().deriveFont(1));
        JLabel lblScrew = new JLabel(this.getTextResource().insertScrewScrew());
        lblScrew.setFont(lblScrew.getFont().deriveFont(1));
        this.setPoseBtn(contributionProvider);
        this.moveHereBtn(contributionProvider);
        JLabel rowsep = new JLabel("");
        rowsep.setPreferredSize(new Dimension(100, 5));
        this.createCkBoxExternalTarget(contributionProvider);
        Box s1Component = this.createLabelInputField(this.s1offSetLabel, this.s1offSetUnitLabel, this.s1Offset, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyboardNumberInput<Double> keyboardInput = ((InsertScrewProgramNodeContribution)contributionProvider.get()).getKeyboardForS1();
                keyboardInput.show(InsertScrewProgramNodeView.this.s1Offset, ((InsertScrewProgramNodeContribution)contributionProvider.get()).getCallbackForS1());
                InsertScrewProgramNodeView.this.drawing.setIcon(InsertScrewProgramNodeView.this.S1.getIcon());
            }
        });
        Box s2Component = this.createLabelInputField(this.s2offSetLabel, this.s2offSetUnitLabel, this.s2Offset, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyboardNumberInput<Double> keyboardInput = ((InsertScrewProgramNodeContribution)contributionProvider.get()).getKeyboardForS2();
                keyboardInput.show(InsertScrewProgramNodeView.this.s2Offset, ((InsertScrewProgramNodeContribution)contributionProvider.get()).getCallbackForS2());
                InsertScrewProgramNodeView.this.drawing.setIcon(InsertScrewProgramNodeView.this.S2.getIcon());
            }
        });
        Box velocityComponent = this.createLabelInputField(this.maxVelocityLabel, this.maxVelocityUnitLabel, this.maxVelocity, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyboardNumberInput<Double> keyboardInput = ((InsertScrewProgramNodeContribution)contributionProvider.get()).getKeyboardVelocity();
                keyboardInput.show(InsertScrewProgramNodeView.this.s2Offset, ((InsertScrewProgramNodeContribution)contributionProvider.get()).getCallbackVelocity());
            }
        });
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(s1Component, -2, -2, -2).addComponent(s2Component, -2, -2, -2).addComponent(velocityComponent, -2, -2, -2).addComponent(sep, -2, -2, Short.MAX_VALUE).addComponent(lblProduct, -2, -2, Short.MAX_VALUE).addComponent(productCB, -2, -2, Short.MAX_VALUE).addComponent(lblScrew, -2, -2, Short.MAX_VALUE).addComponent(screwProgramCB, -2, -2, Short.MAX_VALUE).addComponent(this.setPoseBtn, -2, -2, Short.MAX_VALUE).addComponent(this.moveHereBtn, -2, -2, Short.MAX_VALUE).addComponent(sep2, -2, -2, Short.MAX_VALUE).addComponent(this.ckBoxExternalTarget, -2, -2, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(rowsep, -2, -2, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.infoBtn, -2, -2, -2).addComponent(this.drawing, -2, -2, Short.MAX_VALUE).addGap(2 * this.style.getURComponentHeightDefault())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(s1Component, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(s2Component, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(velocityComponent, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(sep, -2, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(lblProduct, -2, -2, Short.MAX_VALUE).addComponent(productCB, -2, -2, Short.MAX_VALUE).addComponent(lblScrew, -2, -2, Short.MAX_VALUE).addComponent(screwProgramCB, -2, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.setPoseBtn, -2, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.moveHereBtn, -2, -2, Short.MAX_VALUE).addGap(this.style.getVerticalSmallSpacing()).addComponent(sep2, -2, -2, Short.MAX_VALUE).addGap(this.style.getVerticalLargeSpacing()).addComponent(this.ckBoxExternalTarget, -2, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(rowsep, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.infoBtn, -2, -2, -2).addComponent(this.drawing, -2, -2, Short.MAX_VALUE)));
        this.createSafetyPanel(contributionProvider);
        JLabel logoLabel = this.createLogo("/com/spin/urcap/icons/SR_logo200x50.jpg");
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.setAlignmentX(0.0f);
        horizontalBox.add(logoLabel);
        horizontalBox.add(Box.createHorizontalGlue());
        horizontalBox.add(this.safetyPanel);
        Box verticalbox = Box.createVerticalBox();
        verticalbox.setAlignmentX(0.0f);
        verticalbox.setAlignmentY(0.0f);
        verticalbox.add(Box.createVerticalStrut(5));
        verticalbox.add(horizontalBox);
        this.bottomPanel.add((Component)verticalbox, "Last");
        jPanel.add(this.mainPanel);
        jPanel.add(this.bottomPanel);
    }

    private Box createLabelInputField(JLabel label, JLabel unit, JTextField inputField, MouseAdapter mouseAdapter) {
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.setAlignmentX(0.0f);
        label.setHorizontalAlignment(2);
        Dimension d = new Dimension(150, 5);
        label.setPreferredSize(d);
        label.setSize(d);
        unit.setHorizontalAlignment(4);
        inputField.setFocusable(false);
        inputField.setPreferredSize(new Dimension(100, 30));
        inputField.setMaximumSize(inputField.getPreferredSize());
        inputField.addMouseListener(mouseAdapter);
        horizontalBox.add(label);
        horizontalBox.add(Box.createHorizontalGlue());
        horizontalBox.add(inputField);
        horizontalBox.add(Box.createRigidArea(new Dimension(5, 0)));
        horizontalBox.add(unit);
        return horizontalBox;
    }

    private void createSafetyPanel(final ContributionProvider<InsertScrewProgramNodeContribution> contributionProvider) {
        this.safetyPanel = new JPanel();
        this.safetyPanel.setBorder(this.style.getDefaultBtnBoarder());
        GroupLayout layout = new GroupLayout(this.safetyPanel);
        this.safetyPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        this.lblSafetyWarning.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/placeholder_large.png"))));
        this.lblSafetyWarning.setHorizontalAlignment(0);
        this.lblSafetyWarning.setVerticalAlignment(0);
        Box forceInTCPZComponent = this.createLabelInputField(this.forceInTCPZLabel, this.forceInTCPZUnitLabel, this.forceInTCPZ, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyboardNumberInput<Double> keyboardInput = ((InsertScrewProgramNodeContribution)contributionProvider.get()).getKeyboardForForceInTCPZ();
                keyboardInput.show(InsertScrewProgramNodeView.this.forceInTCPZ, ((InsertScrewProgramNodeContribution)contributionProvider.get()).getCallbackForForceInTCPZ());
            }
        });
        this.ckboxEnableSafety = SwingStandards.createCheckBox(this.getTextResource().softSafetyEnable(), 10, this.style.getCheckBoxSize(), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (InsertScrewProgramNodeView.this.ckboxEnableSafety.isSelected()) {
                    InsertScrewProgramNodeView.this.enableSafety = true;
                    InsertScrewProgramNodeView.this.lblSafetyWarning.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/placeholder_large.png"))));
                    InsertScrewProgramNodeView.this.forceInTCPZ.setEnabled(true);
                    InsertScrewProgramNodeView.this.forceInTCPZ.setEditable(true);
                    InsertScrewProgramNodeView.this.forceInTCPZLabel.setEnabled(true);
                    InsertScrewProgramNodeView.this.forceInTCPZUnitLabel.setEnabled(true);
                    InsertScrewProgramNodeView.this.ckboxEnableSafety.setBackground(SwingAbstractStyle.URColor.UR_WHITE);
                    InsertScrewProgramNodeView.this.safetyPanel.setBackground(SwingAbstractStyle.URColor.UR_WHITE);
                } else if (PopupTool.showDialogOptionWarning(InsertScrewProgramNodeView.this.getTextResource().softSafetyPopupText(), InsertScrewProgramNodeView.this.getTextResource().softSafetyPopupTitle(), InsertScrewProgramNodeView.this.getTextResource().optionYes(), InsertScrewProgramNodeView.this.getTextResource().optionNo(), new ImageIcon(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png"))) > 0) {
                    InsertScrewProgramNodeView.this.ckboxEnableSafety.setSelected(true);
                } else {
                    InsertScrewProgramNodeView.this.enableSafety = false;
                    InsertScrewProgramNodeView.this.lblSafetyWarning.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_large.png"))));
                    InsertScrewProgramNodeView.this.forceInTCPZ.setEnabled(false);
                    InsertScrewProgramNodeView.this.forceInTCPZ.setEditable(false);
                    InsertScrewProgramNodeView.this.forceInTCPZLabel.setEnabled(false);
                    InsertScrewProgramNodeView.this.forceInTCPZUnitLabel.setEnabled(false);
                    InsertScrewProgramNodeView.this.ckboxEnableSafety.setBackground(SwingAbstractStyle.URColor.UR_YELLOW);
                    InsertScrewProgramNodeView.this.safetyPanel.setBackground(SwingAbstractStyle.URColor.UR_YELLOW);
                }
                ((InsertScrewProgramNodeContribution)contributionProvider.get()).safetySettingsChanged(InsertScrewProgramNodeView.this.ckboxEnableSafety.isSelected());
            }
        });
        this.ckboxEnableSafety.setSelected(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ckboxEnableSafety, -2, -2, Short.MAX_VALUE).addComponent(forceInTCPZComponent, -2, -2, Short.MAX_VALUE)).addComponent(this.lblSafetyWarning, -2, -2, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(this.ckboxEnableSafety, -2, -2, Short.MAX_VALUE).addComponent(forceInTCPZComponent, -2, -2, Short.MAX_VALUE)).addComponent(this.lblSafetyWarning, -2, -2, Short.MAX_VALUE)));
    }

    private Component createProductComboBox(final ContributionProvider<InsertScrewProgramNodeContribution> contributionProvider) {
        Product[] refProducts = new Product[]{new Product(this.getTextResource().insertScrewSelectProduct())};
        this.productComboBox = new JComboBox<Product>(refProducts);
        this.productComboBox.setFocusable(false);
        this.productComboBox.setPreferredSize(this.style.getComboBoxSize());
        this.productComboBox.setMaximumSize(this.productComboBox.getPreferredSize());
        this.productComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Product selectedProduct = (Product)InsertScrewProgramNodeView.this.productComboBox.getSelectedItem();
                if (selectedProduct != null && !selectedProduct.name.equals(InsertScrewProgramNodeView.this.getTextResource().insertScrewSelectProduct())) {
                    ((InsertScrewProgramNodeContribution)contributionProvider.get()).setSelectedProduct(selectedProduct);
                    ((InsertScrewProgramNodeContribution)contributionProvider.get()).updateScrewProgramComboBox();
                }
            }
        });
        return this.productComboBox;
    }

    public void updateProductComboBox(Product[] products) {
        this.productComboBox.removeAllItems();
        this.productComboBox.addItem(new Product(this.getTextResource().insertScrewSelectProduct()));
        for (Product product : products) {
            this.productComboBox.addItem(product);
        }
    }

    public void setSelectedProduct(Product selectedProduct) {
        if (selectedProduct != null) {
            this.productComboBox.setSelectedItem(selectedProduct);
        }
    }

    private Component createScrewProgramComboBox(final ContributionProvider<InsertScrewProgramNodeContribution> contributionProvider) {
        ScrewProgram[] refScrewPrograms = new ScrewProgram[]{new ScrewProgram(this.getTextResource().insertScrewSelectScrewProgram())};
        this.screwProgramComboBox = new JComboBox<ScrewProgram>(refScrewPrograms);
        this.screwProgramComboBox.setFocusable(false);
        this.screwProgramComboBox.setPreferredSize(this.style.getComboBoxSize());
        this.screwProgramComboBox.setMaximumSize(this.screwProgramComboBox.getPreferredSize());
        this.screwProgramComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrewProgram selectedScrewProgram = (ScrewProgram)InsertScrewProgramNodeView.this.screwProgramComboBox.getSelectedItem();
                if (selectedScrewProgram != null && !selectedScrewProgram.name.equals(InsertScrewProgramNodeView.this.getTextResource().insertScrewSelectScrewProgram())) {
                    ((InsertScrewProgramNodeContribution)contributionProvider.get()).setSelectedScrewProgram(selectedScrewProgram);
                }
            }
        });
        return this.screwProgramComboBox;
    }

    public void updateScrewProgramComboBox(ScrewProgram[] screwPrograms) {
        this.screwProgramComboBox.removeAllItems();
        this.screwProgramComboBox.addItem(new ScrewProgram(this.getTextResource().insertScrewSelectScrewProgram()));
        for (ScrewProgram screwProgram : screwPrograms) {
            this.screwProgramComboBox.addItem(screwProgram);
        }
    }

    public void setSelectedScrewProgram(ScrewProgram selectedScrewProgram) {
        if (selectedScrewProgram != null) {
            this.screwProgramComboBox.setSelectedItem(selectedScrewProgram);
        }
    }

    private void setPoseBtn(final ContributionProvider<InsertScrewProgramNodeContribution> provider) {
        this.setPoseBtn = new JButton();
        this.setPoseBtn.setPreferredSize(this.style.getButtonSizeDefault());
        this.setPoseBtn.setMaximumSize(this.style.getButtonSizeLarge());
        this.setPoseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((InsertScrewProgramNodeContribution)provider.get()).selectPose();
            }
        });
    }

    private void moveHereBtn(final ContributionProvider<InsertScrewProgramNodeContribution> provider) {
        this.moveHereBtn = new JButton();
        this.moveHereBtn.setPreferredSize(this.style.getButtonSizeDefault());
        this.moveHereBtn.setMaximumSize(this.style.getButtonSizeLarge());
        this.moveHereBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((InsertScrewProgramNodeContribution)provider.get()).moveRobot();
            }
        });
    }

    private void createInfoButton() {
        this.infoBtn = new JButton();
        BufferedImage img = null;
        try {
            img = ImageHelper.read("/com/spin/urcap/icons/UR_e-Series_1.0/information_icon.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (img == null) {
            return;
        }
        this.infoBtn.setIcon(new ImageIcon(img));
        this.infoBtn.setPreferredSize(new Dimension(35, 35));
        this.infoBtn.setMaximumSize(this.infoBtn.getPreferredSize());
        this.infoBtn.setBorderPainted(false);
        this.infoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertScrewProgramNodeView.this.mainPanel.setVisible(false);
                InsertScrewProgramNodeView.this.bottomPanel.setVisible(false);
                InsertScrewProgramNodeView.this.jPanel.remove(InsertScrewProgramNodeView.this.mainPanel);
                InsertScrewProgramNodeView.this.jPanel.remove(InsertScrewProgramNodeView.this.bottomPanel);
                InsertScrewProgramNodeView.this.jPanel.add(InsertScrewProgramNodeView.this.infoPanel);
                InsertScrewProgramNodeView.this.infoPanel.setVisible(true);
            }
        });
    }

    private void createInfoPanel(ContributionProvider<InsertScrewProgramNodeContribution> provider) {
        this.infoPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(layout);
        JLabel lblInfoTitle = SwingStandards.createLabel(this.getTextResource().insertScrewInfoTitle(), true, false, new Dimension(450, 50), this.style.getURFontSizeMainHeading());
        JTextArea lblInfoDescription = this.createInfoText(this.getTextResource().insertScrewInfoDescription());
        JButton returnBtn = new JButton(this.getTextResource().optionReturn());
        returnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertScrewProgramNodeView.this.setPanelsVisible();
            }
        });
        JLabel logo = this.createLogo("/com/spin/urcap/icons/SR_logo200x50.jpg");
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(lblInfoTitle, -2, -2, -2).addComponent(lblInfoDescription, -2, -2, -2).addComponent(returnBtn, -2, -2, -2).addComponent(logo, -2, -2, -2)).addGroup(layout.createParallelGroup().addGap(this.style.getHorizontalLargeSpacing() * 5)).addGroup(layout.createParallelGroup()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(lblInfoTitle, -2, -2, -2).addComponent(lblInfoDescription, -2, -2, -2).addComponent(returnBtn, -2, -2, -2).addGap(this.style.getVerticalLargeSpacing() * 9).addComponent(logo, -2, -2, -2)).addGroup(layout.createSequentialGroup()).addGroup(layout.createSequentialGroup()));
    }

    public void setPanelsVisible() {
        this.infoPanel.setVisible(false);
        this.jPanel.remove(this.infoPanel);
        this.jPanel.add(this.mainPanel);
        this.jPanel.add(this.bottomPanel);
        this.mainPanel.setVisible(true);
        this.bottomPanel.setVisible(true);
    }

    private JTextArea createInfoText(String text) {
        JTextArea info = new JTextArea();
        info.setText(text);
        info.setLineWrap(true);
        info.setPreferredSize(new Dimension(650, 110));
        info.setMaximumSize(info.getPreferredSize());
        info.setEditable(false);
        info.setWrapStyleWord(true);
        info.setFont(new Font(info.getFont().getFontName(), this.style.getUrFontStylePlain(), this.style.getUrFontSizeDefault()));
        return info;
    }

    private void createCkBoxExternalTarget(final ContributionProvider<InsertScrewProgramNodeContribution> contributionProvider) {
        this.ckBoxExternalTarget = SwingStandards.createCheckBox(this.getTextResource().insertScrewVariableTargetText(), 10, this.style.getCheckBoxSize(), false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InsertScrewProgramNodeView.this.ckBoxExternalTarget.isSelected()) {
                    InsertScrewProgramNodeView.this.setPoseBtn.setEnabled(false);
                    InsertScrewProgramNodeView.this.moveHereBtn.setEnabled(false);
                    ((InsertScrewProgramNodeContribution)contributionProvider.get()).setCheckBoxExternalTarget(true);
                } else {
                    InsertScrewProgramNodeView.this.setPoseBtn.setEnabled(true);
                    InsertScrewProgramNodeView.this.moveHereBtn.setEnabled(((InsertScrewProgramNodeContribution)contributionProvider.get()).model.get("KEY_BUTTON_VERIFY_INSERTION_POSITION_ENABLED", false));
                    ((InsertScrewProgramNodeContribution)contributionProvider.get()).setCheckBoxExternalTarget(false);
                }
            }
        });
    }

    private TextResource getTextResource() {
        return LanguagePack.getTextResource();
    }

    public void setForceInTCPZLabel(String data) {
        this.forceInTCPZLabel.setText(data);
    }

    public void setForceInTCPZUnitLabel(String data) {
        this.forceInTCPZUnitLabel.setText(data);
    }

    public String getForceInTCPZ() {
        return this.forceInTCPZ.getText();
    }

    public void setForceInTCPZ(String data) {
        this.forceInTCPZ.setText(data);
    }

    public boolean getEnableSafety() {
        return this.enableSafety;
    }

    public void setSetPoseBtn(String data) {
        this.setPoseBtn.setText(data);
    }

    public void setMoveHereBtnText(String data) {
        this.moveHereBtn.setText(data);
    }

    public void enableMoveBtn(boolean bool) {
        this.moveHereBtn.setEnabled(bool);
    }

    public void enableSetPoseBtn(boolean bool) {
        this.setPoseBtn.setEnabled(bool);
    }

    public void setS1OffsetIconWarning() {
        this.s1offSetLabel.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png"))));
    }

    public void setS1OffsetIconNoWarning() {
        this.s1offSetLabel.setIcon(null);
    }

    public void setS1OffSetLabel(String data) {
        this.s1offSetLabel.setText(data);
    }

    public void setS1OffSetUnitLabel(String data) {
        this.s1offSetUnitLabel.setText(data);
    }

    public void setS2offSetLabel(String data) {
        this.s2offSetLabel.setText(data);
    }

    public void setS2offSetUnitLabel(String data) {
        this.s2offSetUnitLabel.setText(data);
    }

    public void setMaxVelocityLabel(String data) {
        this.maxVelocityLabel.setText(data);
    }

    public void setMaxVelocityUnitLabel(String data) {
        this.maxVelocityUnitLabel.setText(data);
    }

    public void setMaxVelocity(String data) {
        this.maxVelocity.setText(data);
    }

    public void setCkBoxExternalTarget(boolean bool) {
        this.ckBoxExternalTarget.setSelected(bool);
    }

    public String getS1Offset() {
        return this.s1Offset.getText();
    }

    public void setS1Offset(String data) {
        this.s1Offset.setText(data);
    }

    public String getS2Offset() {
        return this.s2Offset.getText();
    }

    public void setS2Offset(String data) {
        this.s2Offset.setText(data);
    }

    private JLabel createLogo(String path) {
        JLabel drawing = new JLabel();
        drawing.setHorizontalAlignment(4);
        drawing.setVerticalAlignment(1);
        drawing.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource(path))));
        drawing.setSize(this.style.getDefaultLogoSize());
        return drawing;
    }
}

