/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.util;

import com.spin.urcap.impl.localization.LanguagePack;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.api.domain.value.simple.Time;
import com.ur.urcap.api.domain.value.simple.Torque;

public class SpinUnits {
    private Time.Unit timeUnit;
    private String timeUnitText;
    private Force.Unit forceUnit;
    private String forceUnitText;
    private Length.Unit lengthUnit;
    private String lengthUnitText;
    private Speed.Unit speedUnit;
    private String speedUnitText;
    private Torque.Unit torqueUnit;
    private String torqueUnitText;
    private String retriesCountText;
    private String angularVelocityText;

    public SpinUnits(InstallationAPIProvider apiProvider, LanguagePack languagePack) {
        UnitType unitType = apiProvider.getSystemAPI().getSystemSettings().getLocalization().getUnitType();
        this.timeUnit = Time.Unit.S;
        this.timeUnitText = languagePack.getUnitsResource().UNIT_sec();
        this.retriesCountText = languagePack.getUnitsResource().UNIT_retriesCount();
        this.angularVelocityText = languagePack.getUnitsResource().UNIT_rpm();
        if (unitType.equals((Object)UnitType.METRIC)) {
            this.lengthUnit = Length.Unit.MM;
            this.lengthUnitText = languagePack.getUnitsResource().UNIT_mm();
            this.speedUnit = Speed.Unit.MM_S;
            this.speedUnitText = languagePack.getUnitsResource().UNIT_velocityM();
            this.forceUnit = Force.Unit.N;
            this.forceUnitText = languagePack.getUnitsResource().UNIT_Newton();
            this.torqueUnit = Torque.Unit.NM;
            this.torqueUnitText = languagePack.getUnitsResource().UNIT_nm();
        } else {
            this.lengthUnit = Length.Unit.IN;
            this.lengthUnitText = languagePack.getUnitsResource().UNIT_in();
            this.speedUnit = Speed.Unit.IN_S;
            this.speedUnitText = languagePack.getUnitsResource().UNIT_in();
            this.forceUnit = Force.Unit.LBF;
            this.forceUnitText = languagePack.getUnitsResource().UNIT_lbf();
        }
    }

    public Force.Unit getForceUnit() {
        return this.forceUnit;
    }

    public String getForceUnitText() {
        return this.forceUnitText;
    }

    public Length.Unit getLengthUnit() {
        return this.lengthUnit;
    }

    public String getLengthUnitText() {
        return this.lengthUnitText;
    }

    public Speed.Unit getSpeedUnit() {
        return this.speedUnit;
    }

    public String getSpeedUnitText() {
        return this.speedUnitText;
    }

    public String getRetriesCountText() {
        return this.retriesCountText;
    }

    public Torque.Unit getTorqueUnit() {
        return this.torqueUnit;
    }

    public String getTorqueUnitText() {
        return this.torqueUnitText;
    }

    public Time.Unit getTimeUnit() {
        return this.timeUnit;
    }

    public String getTimeUnitText() {
        return this.timeUnitText;
    }

    public String getAngularVelocityText() {
        return this.angularVelocityText;
    }
}

