/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.component;

import com.spin.ui.urstyle.UR_Color;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JButton;

public abstract class AbstractButton
extends JButton {
    private boolean ctaStyleEnabled = false;

    protected AbstractButton(String text, Icon icon) {
        super(text, icon);
    }

    protected void setHeight(int height) {
        Dimension preferredSize = super.getPreferredSize();
        Dimension maximumSize = super.getMaximumSize();
        Dimension minimumSize = super.getMinimumSize();
        preferredSize.height = height;
        maximumSize.height = height;
        maximumSize.width = Integer.MAX_VALUE;
        minimumSize.height = height;
        minimumSize.width = 0;
        super.setPreferredSize(preferredSize);
        super.setMaximumSize(maximumSize);
        super.setMinimumSize(minimumSize);
    }

    public void enableCallToActionStyle(boolean enable) {
        this.ctaStyleEnabled = enable;
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled && this.ctaStyleEnabled) {
            this.setEnabledCTAColor();
        } else if (this.ctaStyleEnabled) {
            this.setDisabledCTAColor();
        } else if (enabled) {
            this.setEnabledColor();
        } else {
            this.setDisabledColor();
        }
    }

    private void setEnabledColor() {
        this.setBackground(UR_Color.WHITE);
        this.setForeground(UR_Color.BLACK);
    }

    private void setDisabledColor() {
        this.setBackground(UR_Color.WHITE);
        this.setForeground(UR_Color.BLACK);
    }

    private void setEnabledCTAColor() {
        this.setBackground(UR_Color.UR_BLUE);
        this.setForeground(UR_Color.BLACK);
    }

    private void setDisabledCTAColor() {
        this.setBackground(UR_Color.GRAY5);
        this.setForeground(UR_Color.GRAY3);
    }
}

